/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.text;

import com.intellij.lang.ASTNode;
import com.intellij.pom.PomManager;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.events.impl.ChangeInfoImpl;
import com.intellij.pom.tree.events.impl.ReplaceChangeInfoImpl;
import com.intellij.pom.tree.events.impl.TreeChangeEventImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.util.diff.DiffTreeChangeBuilder;
import org.jetbrains.annotations.NotNull;

public class ASTDiffBuilder
implements DiffTreeChangeBuilder<ASTNode, ASTNode> {
    private final TreeChangeEventImpl myEvent;

    public ASTDiffBuilder(@NotNull PsiFileImpl fileImpl) {
        if (fileImpl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileImpl", "com/intellij/psi/impl/source/text/ASTDiffBuilder", "<init>"));
        }
        TreeAspect modelAspect = PomManager.getModel(fileImpl.getProject()).getModelAspect(TreeAspect.class);
        this.myEvent = new TreeChangeEventImpl(modelAspect, fileImpl.getTreeElement());
    }

    @Override
    public void nodeReplaced(@NotNull ASTNode oldNode, @NotNull ASTNode newNode) {
        if (oldNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNode", "com/intellij/psi/impl/source/text/ASTDiffBuilder", "nodeReplaced"));
        }
        if (newNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newNode", "com/intellij/psi/impl/source/text/ASTDiffBuilder", "nodeReplaced"));
        }
        if (!(oldNode instanceof FileElement) || !(newNode instanceof FileElement)) {
            ReplaceChangeInfoImpl change = new ReplaceChangeInfoImpl(newNode);
            change.setReplaced(oldNode);
            this.myEvent.addElementaryChange(newNode, change);
        }
    }

    @Override
    public void nodeDeleted(@NotNull ASTNode parent2, @NotNull ASTNode child) {
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/impl/source/text/ASTDiffBuilder", "nodeDeleted"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/text/ASTDiffBuilder", "nodeDeleted"));
        }
        this.myEvent.addElementaryChange(child, ChangeInfoImpl.create((short)1, child));
    }

    @Override
    public void nodeInserted(@NotNull ASTNode oldParent, @NotNull ASTNode newNode, int pos) {
        if (oldParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldParent", "com/intellij/psi/impl/source/text/ASTDiffBuilder", "nodeInserted"));
        }
        if (newNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newNode", "com/intellij/psi/impl/source/text/ASTDiffBuilder", "nodeInserted"));
        }
        this.myEvent.addElementaryChange(newNode, ChangeInfoImpl.create((short)0, newNode));
    }

    @NotNull
    public TreeChangeEventImpl getEvent() {
        TreeChangeEventImpl treeChangeEventImpl = this.myEvent;
        if (treeChangeEventImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/text/ASTDiffBuilder", "getEvent"));
        }
        return treeChangeEventImpl;
    }
}

