/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class Topic<L> {
    private final String myDisplayName;
    private final Class<L> myListenerClass;
    private final BroadcastDirection myBroadcastDirection;

    public Topic(@NonNls @NotNull String displayName, @NotNull Class<L> listenerClass) {
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/util/messages/Topic", "<init>"));
        }
        if (listenerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listenerClass", "com/intellij/util/messages/Topic", "<init>"));
        }
        this(displayName, listenerClass, BroadcastDirection.TO_CHILDREN);
    }

    public Topic(@NonNls @NotNull String displayName, @NotNull Class<L> listenerClass, BroadcastDirection broadcastDirection) {
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/util/messages/Topic", "<init>"));
        }
        if (listenerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listenerClass", "com/intellij/util/messages/Topic", "<init>"));
        }
        this.myDisplayName = displayName;
        this.myListenerClass = listenerClass;
        this.myBroadcastDirection = broadcastDirection;
    }

    @NotNull
    public Class<L> getListenerClass() {
        Class<L> clazz = this.myListenerClass;
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/messages/Topic", "getListenerClass"));
        }
        return clazz;
    }

    public String toString() {
        return this.myDisplayName;
    }

    public static <L> Topic<L> create(@NonNls @NotNull String displayName, @NotNull Class<L> listenerClass) {
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/util/messages/Topic", "create"));
        }
        if (listenerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listenerClass", "com/intellij/util/messages/Topic", "create"));
        }
        return new Topic<L>(displayName, listenerClass);
    }

    public static <L> Topic<L> create(@NonNls @NotNull String displayName, @NotNull Class<L> listenerClass, BroadcastDirection direction) {
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/util/messages/Topic", "create"));
        }
        if (listenerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listenerClass", "com/intellij/util/messages/Topic", "create"));
        }
        return new Topic<L>(displayName, listenerClass, direction);
    }

    public BroadcastDirection getBroadcastDirection() {
        return this.myBroadcastDirection;
    }

    public static enum BroadcastDirection {
        TO_CHILDREN,
        NONE,
        TO_PARENT;

    }
}

