/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.binding;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.JvmRuntimeTypes;
import org.jetbrains.kotlin.codegen.SamCodegenUtil;
import org.jetbrains.kotlin.codegen.SamType;
import org.jetbrains.kotlin.codegen.SyntheticClassDescriptorForLambda;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.when.SwitchCodegenUtil;
import org.jetbrains.kotlin.codegen.when.WhenByEnumsMapping;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.fileClasses.FileClasses;
import org.jetbrains.kotlin.fileClasses.JvmFileClassesProvider;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.descriptors.SamConstructorDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;

class CodegenAnnotatingVisitor
extends KtVisitorVoid {
    private static final TokenSet BINARY_OPERATIONS = TokenSet.orSet(KtTokens.AUGMENTED_ASSIGNMENTS, TokenSet.create(KtTokens.PLUS, KtTokens.MINUS, KtTokens.MUL, KtTokens.DIV, KtTokens.PERC, KtTokens.RANGE, KtTokens.LT, KtTokens.GT, KtTokens.LTEQ, KtTokens.GTEQ, KtTokens.IDENTIFIER));
    private final Map<String, Integer> anonymousSubclassesCount;
    private final Stack<ClassDescriptor> classStack;
    private final Stack<String> nameStack;
    private final BindingTrace bindingTrace;
    private final BindingContext bindingContext;
    private final GenerationState.GenerateClassFilter filter;
    private final JvmRuntimeTypes runtimeTypes;
    private final JvmFileClassesProvider fileClassesProvider;

    public CodegenAnnotatingVisitor(@NotNull GenerationState state2) {
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "<init>"));
        }
        this.anonymousSubclassesCount = new HashMap<String, Integer>();
        this.classStack = new Stack();
        this.nameStack = new Stack();
        this.bindingTrace = state2.getBindingTrace();
        this.bindingContext = state2.getBindingContext();
        this.filter = state2.getGenerateDeclaredClassFilter();
        this.runtimeTypes = state2.getJvmRuntimeTypes();
        this.fileClassesProvider = state2.getFileClassesProvider();
    }

    @NotNull
    private ClassDescriptor recordClassForCallable(@NotNull KtElement element, @NotNull CallableDescriptor callableDescriptor, @NotNull Collection<KotlinType> supertypes2, @NotNull String name) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClassForCallable"));
        }
        if (callableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableDescriptor", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClassForCallable"));
        }
        if (supertypes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypes", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClassForCallable"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClassForCallable"));
        }
        String simpleName = name.substring(name.lastIndexOf(47) + 1);
        SyntheticClassDescriptorForLambda classDescriptor = new SyntheticClassDescriptorForLambda(this.correctContainerForLambda(callableDescriptor, element), Name.special("<closure-" + simpleName + ">"), supertypes2, element);
        this.bindingTrace.record(CodegenBinding.CLASS_FOR_CALLABLE, callableDescriptor, classDescriptor);
        SyntheticClassDescriptorForLambda syntheticClassDescriptorForLambda = classDescriptor;
        if (syntheticClassDescriptorForLambda == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClassForCallable"));
        }
        return syntheticClassDescriptorForLambda;
    }

    @NotNull
    private DeclarationDescriptor correctContainerForLambda(@NotNull CallableDescriptor descriptor2, @NotNull KtElement function) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "correctContainerForLambda"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "correctContainerForLambda"));
        }
        DeclarationDescriptor container = descriptor2.getContainingDeclaration();
        if (container instanceof ConstructorDescriptor && DescriptorUtils.isAnonymousObject(container.getContainingDeclaration())) {
            PsiElement element = function;
            while (element != null) {
                KtElement child = element;
                if (this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, element = element.getParent()) == container) {
                    DeclarationDescriptor declarationDescriptor = container;
                    if (declarationDescriptor == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "correctContainerForLambda"));
                    }
                    return declarationDescriptor;
                }
                if (!(element instanceof KtObjectDeclaration) || !(element.getParent() instanceof KtObjectLiteralExpression) || !(child instanceof KtSuperTypeList)) continue;
                container = container.getContainingDeclaration().getContainingDeclaration();
            }
        }
        DeclarationDescriptor declarationDescriptor = container;
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "correctContainerForLambda"));
        }
        return declarationDescriptor;
    }

    @NotNull
    private String inventAnonymousClassName() {
        String top = CodegenAnnotatingVisitor.peekFromStack(this.nameStack);
        Integer cnt = this.anonymousSubclassesCount.get(top);
        if (cnt == null) {
            cnt = 0;
        }
        this.anonymousSubclassesCount.put(top, cnt + 1);
        String string = top + "$" + (cnt + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "inventAnonymousClassName"));
        }
        return string;
    }

    @Override
    public void visitKtElement(@NotNull KtElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitKtElement"));
        }
        super.visitKtElement(element);
        element.acceptChildren(this);
    }

    @Override
    public void visitScript(@NotNull KtScript script) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitScript"));
        }
        this.classStack.push(this.bindingContext.get(BindingContext.SCRIPT, script));
        this.nameStack.push(AsmUtil.internalNameByFqNameWithoutInnerClasses(script.getFqName()));
        script.acceptChildren(this);
        this.nameStack.pop();
        this.classStack.pop();
    }

    @Override
    public void visitKtFile(@NotNull KtFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitKtFile"));
        }
        this.nameStack.push(AsmUtil.internalNameByFqNameWithoutInnerClasses(file.getPackageFqName()));
        file.acceptChildren(this);
        this.nameStack.pop();
    }

    @Override
    public void visitEnumEntry(@NotNull KtEnumEntry enumEntry) {
        if (enumEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntry", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitEnumEntry"));
        }
        if (enumEntry.getDeclarations().isEmpty()) {
            for (KtSuperTypeListEntry specifier : enumEntry.getSuperTypeListEntries()) {
                specifier.accept(this);
            }
            return;
        }
        ClassDescriptor descriptor2 = this.bindingContext.get(BindingContext.CLASS, enumEntry);
        if (descriptor2 == null) {
            return;
        }
        this.bindingTrace.record(CodegenBinding.ENUM_ENTRY_CLASS_NEED_SUBCLASS, descriptor2);
        super.visitEnumEntry(enumEntry);
    }

    @Override
    public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitObjectDeclaration"));
        }
        if (!this.filter.shouldAnnotateClass(declaration)) {
            return;
        }
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, declaration);
        if (classDescriptor == null) {
            return;
        }
        String name = this.getName(classDescriptor);
        this.recordClosure(classDescriptor, name);
        this.classStack.push(classDescriptor);
        this.nameStack.push(name);
        super.visitObjectDeclaration(declaration);
        this.nameStack.pop();
        this.classStack.pop();
    }

    @Override
    public void visitClass(@NotNull KtClass klass) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitClass"));
        }
        if (!this.filter.shouldAnnotateClass(klass)) {
            return;
        }
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, klass);
        if (classDescriptor == null) {
            return;
        }
        String name = this.getName(classDescriptor);
        this.recordClosure(classDescriptor, name);
        this.classStack.push(classDescriptor);
        this.nameStack.push(name);
        super.visitClass(klass);
        this.nameStack.pop();
        this.classStack.pop();
    }

    private String getName(ClassDescriptor classDescriptor) {
        String base = CodegenAnnotatingVisitor.peekFromStack(this.nameStack);
        Name descriptorName = SpecialNames.safeIdentifier(classDescriptor.getName());
        return DescriptorUtils.isTopLevelDeclaration(classDescriptor) ? (base.isEmpty() ? descriptorName.asString() : base + '/' + descriptorName) : base + '$' + descriptorName;
    }

    @Override
    public void visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitObjectLiteralExpression"));
        }
        KtObjectDeclaration object = expression.getObjectDeclaration();
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, object);
        if (classDescriptor == null) {
            super.visitObjectLiteralExpression(expression);
            return;
        }
        String name = this.inventAnonymousClassName();
        this.recordClosure(classDescriptor, name);
        KtSuperTypeList delegationSpecifierList = object.getSuperTypeList();
        if (delegationSpecifierList != null) {
            delegationSpecifierList.accept(this);
        }
        this.classStack.push(classDescriptor);
        this.nameStack.push(CodegenBinding.getAsmType(this.bindingContext, classDescriptor).getInternalName());
        KtClassBody body = object.getBody();
        if (body != null) {
            super.visitClassBody(body);
        }
        this.nameStack.pop();
        this.classStack.pop();
    }

    @Override
    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
        if (lambdaExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambdaExpression", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitLambdaExpression"));
        }
        KtFunctionLiteral functionLiteral = lambdaExpression.getFunctionLiteral();
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, functionLiteral);
        if (functionDescriptor == null) {
            return;
        }
        String name = this.inventAnonymousClassName();
        Collection<KotlinType> supertypes2 = this.runtimeTypes.getSupertypesForClosure(functionDescriptor);
        ClassDescriptor classDescriptor = this.recordClassForCallable(functionLiteral, functionDescriptor, supertypes2, name);
        this.recordClosure(classDescriptor, name);
        this.classStack.push(classDescriptor);
        this.nameStack.push(name);
        super.visitLambdaExpression(lambdaExpression);
        this.nameStack.pop();
        this.classStack.pop();
    }

    @Override
    public void visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression) {
        Collection<KotlinType> supertypes2;
        CallableDescriptor callableDescriptor;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitCallableReferenceExpression"));
        }
        ResolvedCall<? extends CallableDescriptor> referencedFunction = CallUtilKt.getResolvedCall(expression.getCallableReference(), this.bindingContext);
        if (referencedFunction == null) {
            return;
        }
        CallableDescriptor target = referencedFunction.getResultingDescriptor();
        if (target instanceof FunctionDescriptor) {
            callableDescriptor = this.bindingContext.get(BindingContext.FUNCTION, expression);
            if (callableDescriptor == null) {
                return;
            }
            supertypes2 = this.runtimeTypes.getSupertypesForFunctionReference((FunctionDescriptor)target);
        } else if (target instanceof PropertyDescriptor) {
            callableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, expression);
            if (callableDescriptor == null) {
                return;
            }
            supertypes2 = Collections.singleton(this.runtimeTypes.getSupertypeForPropertyReference((PropertyDescriptor)target));
        } else {
            return;
        }
        String name = this.inventAnonymousClassName();
        ClassDescriptor classDescriptor = this.recordClassForCallable(expression, callableDescriptor, supertypes2, name);
        this.recordClosure(classDescriptor, name);
        this.classStack.push(classDescriptor);
        this.nameStack.push(name);
        super.visitCallableReferenceExpression(expression);
        this.nameStack.pop();
        this.classStack.pop();
    }

    private void recordClosure(@NotNull ClassDescriptor classDescriptor, @NotNull String name) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClosure"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClosure"));
        }
        CodegenBinding.recordClosure(this.bindingTrace, classDescriptor, CodegenAnnotatingVisitor.peekFromStack(this.classStack), Type.getObjectType(name), this.fileClassesProvider);
    }

    @Override
    public void visitProperty(@NotNull KtProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitProperty"));
        }
        DeclarationDescriptor descriptor2 = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, property);
        if (descriptor2 == null) {
            return;
        }
        String nameForClassOrPackageMember = this.getNameForClassOrPackageMember(descriptor2);
        if (nameForClassOrPackageMember != null) {
            this.nameStack.push(nameForClassOrPackageMember);
        } else {
            this.nameStack.push(CodegenAnnotatingVisitor.peekFromStack(this.nameStack) + '$' + SpecialNames.safeIdentifier(property.getNameAsSafeName()).asString());
        }
        KtPropertyDelegate delegate2 = property.getDelegate();
        if (delegate2 != null && descriptor2 instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor2;
            String name = this.inventAnonymousClassName();
            KotlinType supertype = this.runtimeTypes.getSupertypeForPropertyReference(propertyDescriptor);
            ClassDescriptor classDescriptor = this.recordClassForCallable(delegate2, propertyDescriptor, Collections.singleton(supertype), name);
            this.recordClosure(classDescriptor, name);
        }
        super.visitProperty(property);
        this.nameStack.pop();
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitNamedFunction"));
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, function);
        if (functionDescriptor == null) {
            return;
        }
        String nameForClassOrPackageMember = this.getNameForClassOrPackageMember(functionDescriptor);
        if (nameForClassOrPackageMember != null) {
            this.nameStack.push(nameForClassOrPackageMember);
            super.visitNamedFunction(function);
            this.nameStack.pop();
        } else {
            String name = this.inventAnonymousClassName();
            Collection<KotlinType> supertypes2 = this.runtimeTypes.getSupertypesForClosure(functionDescriptor);
            ClassDescriptor classDescriptor = this.recordClassForCallable(function, functionDescriptor, supertypes2, name);
            this.recordClosure(classDescriptor, name);
            this.classStack.push(classDescriptor);
            this.nameStack.push(name);
            super.visitNamedFunction(function);
            this.nameStack.pop();
            this.classStack.pop();
        }
    }

    @Nullable
    private String getNameForClassOrPackageMember(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "getNameForClassOrPackageMember"));
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        String peek = CodegenAnnotatingVisitor.peekFromStack(this.nameStack);
        String name = SpecialNames.safeIdentifier(descriptor2.getName()).asString();
        if (containingDeclaration instanceof ClassDescriptor) {
            return peek + '$' + name;
        }
        if (containingDeclaration instanceof PackageFragmentDescriptor) {
            KtFile containingFile = DescriptorToSourceUtils.getContainingFile(descriptor2);
            assert (containingFile != null) : "File not found for " + descriptor2;
            return FileClasses.getFileClassInternalName(this.fileClassesProvider, containingFile) + '$' + name;
        }
        return null;
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitCallExpression"));
        }
        super.visitCallExpression(expression);
        this.checkSamCall(expression);
    }

    private void checkSamCall(@NotNull KtCallElement expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "checkSamCall"));
        }
        ResolvedCall<? extends CallableDescriptor> call = CallUtilKt.getResolvedCall(expression, this.bindingContext);
        if (call == null) {
            return;
        }
        CallableDescriptor descriptor2 = call.getResultingDescriptor();
        if (!(descriptor2 instanceof FunctionDescriptor)) {
            return;
        }
        this.recordSamConstructorIfNeeded(expression, call);
        FunctionDescriptor original = SamCodegenUtil.getOriginalIfSamAdapter((FunctionDescriptor)descriptor2);
        if (original == null) {
            return;
        }
        List<ResolvedValueArgument> valueArguments2 = call.getValueArgumentsByIndex();
        if (valueArguments2 == null) {
            return;
        }
        for (ValueParameterDescriptor valueParameter : original.getValueParameters()) {
            SamType samType = SamType.create(valueParameter.getType());
            if (samType == null) continue;
            ResolvedValueArgument resolvedValueArgument = valueArguments2.get(valueParameter.getIndex());
            assert (resolvedValueArgument instanceof ExpressionValueArgument) : resolvedValueArgument;
            ValueArgument valueArgument = ((ExpressionValueArgument)resolvedValueArgument).getValueArgument();
            assert (valueArgument != null);
            KtExpression argumentExpression = valueArgument.getArgumentExpression();
            assert (argumentExpression != null) : valueArgument.asElement().getText();
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, argumentExpression, samType);
        }
    }

    @Override
    public void visitSuperTypeCallEntry(@NotNull KtSuperTypeCallEntry call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitSuperTypeCallEntry"));
        }
        super.visitSuperTypeCallEntry(call);
        this.checkSamCall(call);
    }

    private void recordSamConstructorIfNeeded(@NotNull KtCallElement expression, @NotNull ResolvedCall<?> call) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordSamConstructorIfNeeded"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordSamConstructorIfNeeded"));
        }
        Object callableDescriptor = call.getResultingDescriptor();
        if (!(callableDescriptor.getOriginal() instanceof SamConstructorDescriptor)) {
            return;
        }
        List<ResolvedValueArgument> valueArguments2 = call.getValueArgumentsByIndex();
        if (valueArguments2 == null || valueArguments2.size() != 1) {
            return;
        }
        ResolvedValueArgument valueArgument = valueArguments2.get(0);
        if (!(valueArgument instanceof ExpressionValueArgument)) {
            return;
        }
        ValueArgument argument = ((ExpressionValueArgument)valueArgument).getValueArgument();
        if (argument == null) {
            return;
        }
        KtExpression argumentExpression = argument.getArgumentExpression();
        this.bindingTrace.record(CodegenBinding.SAM_CONSTRUCTOR_TO_ARGUMENT, expression, argumentExpression);
        SamType samType = SamType.create(callableDescriptor.getReturnType());
        this.bindingTrace.record(CodegenBinding.SAM_VALUE, argumentExpression, samType);
    }

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitBinaryExpression"));
        }
        super.visitBinaryExpression(expression);
        DeclarationDescriptor operationDescriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression.getOperationReference());
        if (!(operationDescriptor instanceof FunctionDescriptor)) {
            return;
        }
        FunctionDescriptor original = SamCodegenUtil.getOriginalIfSamAdapter((FunctionDescriptor)operationDescriptor);
        if (original == null) {
            return;
        }
        SamType samType = SamType.create(original.getValueParameters().get(0).getType());
        if (samType == null) {
            return;
        }
        IElementType token = expression.getOperationToken();
        if (BINARY_OPERATIONS.contains(token)) {
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, expression.getRight(), samType);
        } else if (token == KtTokens.IN_KEYWORD || token == KtTokens.NOT_IN) {
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, expression.getLeft(), samType);
        }
    }

    @Override
    public void visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitArrayAccessExpression"));
        }
        super.visitArrayAccessExpression(expression);
        DeclarationDescriptor operationDescriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression);
        if (!(operationDescriptor instanceof FunctionDescriptor)) {
            return;
        }
        boolean isSetter = operationDescriptor.getName().asString().equals("set");
        FunctionDescriptor original = SamCodegenUtil.getOriginalIfSamAdapter((FunctionDescriptor)operationDescriptor);
        if (original == null) {
            return;
        }
        List<KtExpression> indexExpressions = expression.getIndexExpressions();
        List<ValueParameterDescriptor> parameters2 = original.getValueParameters();
        for (ValueParameterDescriptor valueParameter : parameters2) {
            SamType samType = SamType.create(valueParameter.getType());
            if (samType == null) continue;
            if (isSetter && valueParameter.getIndex() == parameters2.size() - 1) {
                PsiElement parent2 = expression.getParent();
                if (!(parent2 instanceof KtBinaryExpression) || ((KtBinaryExpression)parent2).getOperationToken() != KtTokens.EQ) continue;
                KtExpression right = ((KtBinaryExpression)parent2).getRight();
                this.bindingTrace.record(CodegenBinding.SAM_VALUE, right, samType);
                continue;
            }
            KtExpression indexExpression = indexExpressions.get(valueParameter.getIndex());
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, indexExpression, samType);
        }
    }

    @Override
    public void visitWhenExpression(@NotNull KtWhenExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitWhenExpression"));
        }
        super.visitWhenExpression(expression);
        if (!this.isWhenWithEnums(expression)) {
            return;
        }
        String currentClassName = this.getCurrentTopLevelClassOrPackagePartInternalName(expression.getContainingKtFile());
        if (this.bindingContext.get(CodegenBinding.MAPPINGS_FOR_WHENS_BY_ENUM_IN_CLASS_FILE, currentClassName) == null) {
            this.bindingTrace.record(CodegenBinding.MAPPINGS_FOR_WHENS_BY_ENUM_IN_CLASS_FILE, currentClassName, new ArrayList(1));
        }
        List<WhenByEnumsMapping> mappings = this.bindingContext.get(CodegenBinding.MAPPINGS_FOR_WHENS_BY_ENUM_IN_CLASS_FILE, currentClassName);
        assert (mappings != null) : "guaranteed by contract";
        int fieldNumber = mappings.size();
        assert (expression.getSubjectExpression() != null) : "subject expression should be not null in a valid when by enums";
        KotlinType type2 = this.bindingContext.getType(expression.getSubjectExpression());
        assert (type2 != null) : "should not be null in a valid when by enums";
        ClassDescriptor classDescriptor = (ClassDescriptor)type2.getConstructor().getDeclarationDescriptor();
        assert (classDescriptor != null) : "because it's enum";
        WhenByEnumsMapping mapping = new WhenByEnumsMapping(classDescriptor, currentClassName, fieldNumber);
        for (ConstantValue<?> constant : SwitchCodegenUtil.getAllConstants(expression, this.bindingContext)) {
            if (constant instanceof NullValue) continue;
            assert (constant instanceof EnumValue) : "expression in when should be EnumValue";
            mapping.putFirstTime((EnumValue)constant, mapping.size() + 1);
        }
        mappings.add(mapping);
        this.bindingTrace.record(CodegenBinding.MAPPING_FOR_WHEN_BY_ENUM, expression, mapping);
    }

    private boolean isWhenWithEnums(@NotNull KtWhenExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "isWhenWithEnums"));
        }
        return WhenChecker.isWhenByEnum(expression, this.bindingContext) && SwitchCodegenUtil.checkAllItemsAreConstantsSatisfying(expression, this.bindingContext, new Function1<ConstantValue<?>, Boolean>(){

            @Override
            public Boolean invoke(@NotNull ConstantValue<?> constant) {
                if (constant == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constant", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor$1", "invoke"));
                }
                return constant instanceof EnumValue || constant instanceof NullValue;
            }
        });
    }

    @NotNull
    private String getCurrentTopLevelClassOrPackagePartInternalName(@NotNull KtFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "getCurrentTopLevelClassOrPackagePartInternalName"));
        }
        ListIterator iterator2 = this.classStack.listIterator(this.classStack.size());
        while (iterator2.hasPrevious()) {
            ClassDescriptor previous = (ClassDescriptor)iterator2.previous();
            if (!DescriptorUtils.isTopLevelOrInnerClass(previous)) continue;
            String string = CodegenBinding.getAsmType(this.bindingContext, previous).getInternalName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "getCurrentTopLevelClassOrPackagePartInternalName"));
            }
            return string;
        }
        String string = FileClasses.getFacadeClassInternalName(this.fileClassesProvider, file);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "getCurrentTopLevelClassOrPackagePartInternalName"));
        }
        return string;
    }

    private static <T> T peekFromStack(@NotNull Stack<T> stack) {
        if (stack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stack", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "peekFromStack"));
        }
        return stack.empty() ? null : (T)stack.peek();
    }
}

