/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.binding.CalculatedClosure;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.EnclosedValueDescriptor;
import org.jetbrains.kotlin.codegen.inline.CapturedParamDesc;
import org.jetbrains.kotlin.codegen.inline.CapturedParamInfo;
import org.jetbrains.kotlin.codegen.inline.CapturedParamOwner;
import org.jetbrains.kotlin.codegen.inline.FieldRemapper;
import org.jetbrains.kotlin.codegen.inline.InlineCodegen;
import org.jetbrains.kotlin.codegen.inline.LabelOwner;
import org.jetbrains.kotlin.codegen.inline.Parameters;
import org.jetbrains.kotlin.codegen.inline.ParametersBuilder;
import org.jetbrains.kotlin.codegen.inline.SMAPAndMethodNode;
import org.jetbrains.kotlin.codegen.state.JetTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;

public class LambdaInfo
implements CapturedParamOwner,
LabelOwner {
    public final KtExpression expression;
    private final JetTypeMapper typeMapper;
    @NotNull
    public final Set<String> labels;
    private final CalculatedClosure closure;
    public final boolean isCrossInline;
    private SMAPAndMethodNode node;
    private List<CapturedParamDesc> capturedVars;
    private final FunctionDescriptor functionDescriptor;
    private final ClassDescriptor classDescriptor;
    private final Type closureClassType;

    LambdaInfo(@NotNull KtExpression expr, @NotNull JetTypeMapper typeMapper, boolean isCrossInline) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "org/jetbrains/kotlin/codegen/inline/LambdaInfo", "<init>"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/inline/LambdaInfo", "<init>"));
        }
        this.isCrossInline = isCrossInline;
        this.expression = expr instanceof KtLambdaExpression ? ((KtLambdaExpression)expr).getFunctionLiteral() : expr;
        this.typeMapper = typeMapper;
        BindingContext bindingContext = typeMapper.getBindingContext();
        this.functionDescriptor = bindingContext.get(BindingContext.FUNCTION, this.expression);
        assert (this.functionDescriptor != null) : "Function is not resolved to descriptor: " + this.expression.getText();
        this.classDescriptor = CodegenBinding.anonymousClassForCallable(bindingContext, this.functionDescriptor);
        this.closureClassType = CodegenBinding.asmTypeForAnonymousClass(bindingContext, this.functionDescriptor);
        this.closure = bindingContext.get(CodegenBinding.CLOSURE, this.classDescriptor);
        assert (this.closure != null) : "Closure for lambda should be not null " + this.expression.getText();
        this.labels = InlineCodegen.getDeclarationLabels(expr, this.functionDescriptor);
    }

    public SMAPAndMethodNode getNode() {
        return this.node;
    }

    public void setNode(SMAPAndMethodNode node) {
        this.node = node;
    }

    public FunctionDescriptor getFunctionDescriptor() {
        return this.functionDescriptor;
    }

    public KtExpression getFunctionWithBodyOrCallableReference() {
        return this.expression;
    }

    public ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    public Type getLambdaClassType() {
        return this.closureClassType;
    }

    public List<CapturedParamDesc> getCapturedVars() {
        if (this.capturedVars == null) {
            EnclosedValueDescriptor descriptor22;
            Type type2;
            this.capturedVars = new ArrayList<CapturedParamDesc>();
            if (this.closure.getCaptureThis() != null) {
                type2 = this.typeMapper.mapType(this.closure.getCaptureThis());
                descriptor22 = new EnclosedValueDescriptor("this$0", null, StackValue.field(type2, this.closureClassType, "this$0", false, StackValue.LOCAL_0), type2);
                this.capturedVars.add(this.getCapturedParamInfo(descriptor22));
            }
            if (this.closure.getCaptureReceiverType() != null) {
                type2 = this.typeMapper.mapType(this.closure.getCaptureReceiverType());
                descriptor22 = new EnclosedValueDescriptor("receiver$0", null, StackValue.field(type2, this.closureClassType, "receiver$0", false, StackValue.LOCAL_0), type2);
                this.capturedVars.add(this.getCapturedParamInfo(descriptor22));
            }
            for (EnclosedValueDescriptor descriptor22 : this.closure.getCaptureVariables().values()) {
                this.capturedVars.add(this.getCapturedParamInfo(descriptor22));
            }
        }
        return this.capturedVars;
    }

    @NotNull
    private CapturedParamDesc getCapturedParamInfo(@NotNull EnclosedValueDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/inline/LambdaInfo", "getCapturedParamInfo"));
        }
        CapturedParamDesc capturedParamDesc = CapturedParamDesc.createDesc(this, descriptor2.getFieldName(), descriptor2.getType());
        if (capturedParamDesc == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/LambdaInfo", "getCapturedParamInfo"));
        }
        return capturedParamDesc;
    }

    @NotNull
    public List<Type> getInvokeParamsWithoutCaptured() {
        Type[] types2 = this.typeMapper.mapSignature(this.functionDescriptor).getAsmMethod().getArgumentTypes();
        List<Type> list2 = Arrays.asList(types2);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/LambdaInfo", "getInvokeParamsWithoutCaptured"));
        }
        return list2;
    }

    @NotNull
    public Parameters addAllParameters(FieldRemapper remapper) {
        JvmMethodSignature signature = this.typeMapper.mapSignature(this.getFunctionDescriptor());
        ParametersBuilder builder = ParametersBuilder.initializeBuilderFrom(AsmTypes.OBJECT_TYPE, signature.getAsmMethod().getDescriptor(), this);
        for (CapturedParamDesc info : this.getCapturedVars()) {
            CapturedParamInfo field = remapper.findField(new FieldInsnNode(0, info.getContainingLambdaName(), info.getFieldName(), ""));
            builder.addCapturedParam(field, info.getFieldName());
        }
        Parameters parameters2 = builder.buildParameters();
        if (parameters2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/LambdaInfo", "addAllParameters"));
        }
        return parameters2;
    }

    @Override
    public Type getType() {
        return this.closureClassType;
    }

    @Override
    public boolean isMyLabel(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/inline/LambdaInfo", "isMyLabel"));
        }
        return this.labels.contains(name);
    }
}

