/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util.rewriters;

import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsFunctionScope;
import com.google.dart.compiler.backend.js.ast.JsLabel;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsVisitorWithContextImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.inline.context.NamingContext;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J\u001c\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u00132\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J\u001c\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/js/inline/util/rewriters/LabelNameRefreshingVisitor;", "Lcom/google/dart/compiler/backend/js/ast/JsVisitorWithContextImpl;", "context", "Lorg/jetbrains/kotlin/js/inline/context/NamingContext;", "functionScope", "Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope;", "(Lorg/jetbrains/kotlin/js/inline/context/NamingContext;Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope;)V", "getContext", "()Lorg/jetbrains/kotlin/js/inline/context/NamingContext;", "getFunctionScope", "()Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope;", "endVisit", "", "x", "Lcom/google/dart/compiler/backend/js/ast/JsLabel;", "ctx", "Lcom/google/dart/compiler/backend/js/ast/JsContext;", "visit", "", "Lcom/google/dart/compiler/backend/js/ast/JsFunction;", "kotlin-compiler"})
public final class LabelNameRefreshingVisitor
extends JsVisitorWithContextImpl {
    @NotNull
    private final NamingContext context;
    @NotNull
    private final JsFunctionScope functionScope;

    public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        return false;
    }

    public boolean visit(@NotNull JsLabel x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        JsName labelName = x.getName();
        String string = labelName.getIdent();
        Intrinsics.checkExpressionValueIsNotNull(string, "labelName.ident");
        JsName freshName = this.functionScope.enterLabel(string);
        if (Intrinsics.areEqual(freshName.getIdent(), labelName.getIdent()) ^ true) {
            JsName jsName = labelName;
            Intrinsics.checkExpressionValueIsNotNull(jsName, "labelName");
            JsExpression jsExpression = freshName.makeRef();
            Intrinsics.checkExpressionValueIsNotNull(jsExpression, "freshName.makeRef()");
            this.context.replaceName(jsName, jsExpression);
        }
        return super.visit(x, ctx);
    }

    public void endVisit(@NotNull JsLabel x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        super.endVisit(x, ctx);
        this.functionScope.exitLabel();
    }

    @NotNull
    public final NamingContext getContext() {
        return this.context;
    }

    @NotNull
    public final JsFunctionScope getFunctionScope() {
        return this.functionScope;
    }

    public LabelNameRefreshingVisitor(@NotNull NamingContext context, @NotNull JsFunctionScope functionScope) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(functionScope, "functionScope");
        this.context = context;
        this.functionScope = functionScope;
    }
}

