/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import com.google.dart.compiler.backend.js.ast.DelegatingJsFunctionScopeWithTemporaryParent;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsExpressionStatement;
import com.google.dart.compiler.backend.js.ast.JsFunctionScope;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.backend.js.ast.JsRootScope;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.gwt.dev.js.ThrowExceptionOnErrorReporter;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.parser.ParserUtilsKt;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsCallChecker;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.reference.AbstractCallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.utils.InlineUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;

public final class CallExpressionTranslator
extends AbstractCallExpressionTranslator {
    @NotNull
    public static JsNode translate(@NotNull KtCallExpression expression, @Nullable JsExpression receiver, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translate"));
        }
        ResolvedCall<? extends FunctionDescriptor> resolvedCall2 = CallUtilKt.getFunctionResolvedCallWithAssert(expression, context.bindingContext());
        if (JsCallChecker.isJsCall(resolvedCall2)) {
            JsNode jsNode = new CallExpressionTranslator(expression, receiver, context).translateJsCode();
            if (jsNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translate"));
            }
            return jsNode;
        }
        JsExpression callExpression = new CallExpressionTranslator(expression, receiver, context).translate();
        if (!resolvedCall2.isSafeCall() && CallExpressionTranslator.shouldBeInlined(expression, context)) {
            InlineUtils.setInlineCallMetadata(callExpression, expression, resolvedCall2, context);
        }
        JsExpression jsExpression = callExpression;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translate"));
        }
        return jsExpression;
    }

    public static boolean shouldBeInlined(@NotNull KtCallExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "shouldBeInlined"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "shouldBeInlined"));
        }
        if (!context.getConfig().isInlineEnabled()) {
            return false;
        }
        CallableDescriptor descriptor2 = PsiUtils.getFunctionDescriptor(expression, context);
        return CallExpressionTranslator.shouldBeInlined(descriptor2);
    }

    public static boolean shouldBeInlined(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "shouldBeInlined"));
        }
        if (descriptor2 instanceof SimpleFunctionDescriptor) {
            return InlineUtil.isInline(descriptor2);
        }
        if (descriptor2 instanceof ValueParameterDescriptor) {
            return InlineUtil.isInline(descriptor2.getContainingDeclaration()) && InlineUtil.isInlineLambdaParameter((ParameterDescriptor)descriptor2);
        }
        return false;
    }

    private CallExpressionTranslator(@NotNull KtCallExpression expression, @Nullable JsExpression receiver, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "<init>"));
        }
        super(expression, receiver, context);
    }

    @NotNull
    private JsExpression translate() {
        JsExpression jsExpression = CallTranslator.translate(this.context(), this.resolvedCall, this.receiver);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translate"));
        }
        return jsExpression;
    }

    @NotNull
    private JsNode translateJsCode() {
        List<KtValueArgument> arguments2 = this.expression.getValueArguments();
        KtExpression argumentExpression = ((ValueArgument)arguments2.get(0)).getArgumentExpression();
        assert (argumentExpression != null);
        List<JsStatement> statements = this.parseJsCode(argumentExpression);
        int size = statements.size();
        if (size == 0) {
            JsExpression jsExpression = this.program().getEmptyExpression();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translateJsCode"));
            }
            return jsExpression;
        }
        if (size > 1) {
            JsBlock jsBlock = new JsBlock(statements);
            if (jsBlock == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translateJsCode"));
            }
            return jsBlock;
        }
        JsStatement resultStatement = statements.get(0);
        if (resultStatement instanceof JsExpressionStatement) {
            JsExpression jsExpression = ((JsExpressionStatement)resultStatement).getExpression();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translateJsCode"));
            }
            return jsExpression;
        }
        JsStatement jsStatement = resultStatement;
        if (jsStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "translateJsCode"));
        }
        return jsStatement;
    }

    @NotNull
    private List<JsStatement> parseJsCode(@NotNull KtExpression jsCodeExpression) {
        if (jsCodeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsCodeExpression", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "parseJsCode"));
        }
        String jsCode = JsCallChecker.extractStringValue(ConstantExpressionEvaluator.getConstant(jsCodeExpression, this.context().bindingContext()));
        assert (jsCode != null) : "jsCode must be compile time string " + jsCodeExpression.getText();
        JsScope currentScope = this.context().scope();
        assert (currentScope instanceof JsFunctionScope) : "Usage of js outside of function is unexpected";
        JsRootScope temporaryRootScope = new JsRootScope(new JsProgram("<js code>"));
        DelegatingJsFunctionScopeWithTemporaryParent scope2 = new DelegatingJsFunctionScopeWithTemporaryParent((JsFunctionScope)currentScope, temporaryRootScope);
        List<JsStatement> list2 = ParserUtilsKt.parse(jsCode, ThrowExceptionOnErrorReporter.INSTANCE, scope2);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallExpressionTranslator", "parseJsCode"));
        }
        return list2;
    }
}

