/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jvm;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.jvm.RuntimeAssertionInfo;
import org.jetbrains.kotlin.jvm.bindingContextSlices.BindingContextSlicesKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J,\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/jvm/RuntimeAssertionsTypeChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "()V", "checkReceiver", "", "receiverParameter", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "receiverArgument", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "safeAccess", "", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/CallResolutionContext;", "checkType", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionTypeWithSmartCast", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "kotlin-compiler"})
public final class RuntimeAssertionsTypeChecker
implements AdditionalTypeChecker {
    public static final RuntimeAssertionsTypeChecker INSTANCE;

    @Override
    public void checkType(@NotNull KtExpression expression, @NotNull KotlinType expressionType, @NotNull KotlinType expressionTypeWithSmartCast, @NotNull ResolutionContext<?> c) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(expressionType, "expressionType");
        Intrinsics.checkParameterIsNotNull(expressionTypeWithSmartCast, "expressionTypeWithSmartCast");
        Intrinsics.checkParameterIsNotNull(c, "c");
        if (TypeUtils.noExpectedType(c.expectedType)) {
            return;
        }
        KotlinType kotlinType = c.expectedType;
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "c.expectedType");
        RuntimeAssertionInfo assertionInfo2 = RuntimeAssertionInfo.Companion.create(kotlinType, expressionType, new RuntimeAssertionInfo.DataFlowExtras(c, expression, expressionType){
            private final DataFlowValue dataFlowValue;
            final /* synthetic */ ResolutionContext $c;
            final /* synthetic */ KtExpression $expression;
            final /* synthetic */ KotlinType $expressionType;

            public boolean getCanBeNull() {
                DataFlowInfo dataFlowInfo = this.$c.dataFlowInfo;
                DataFlowValue dataFlowValue = this.dataFlowValue;
                Intrinsics.checkExpressionValueIsNotNull(dataFlowValue, "dataFlowValue");
                return dataFlowInfo.getPredictableNullability(dataFlowValue).canBeNull();
            }

            @NotNull
            public Set<KotlinType> getPossibleTypes() {
                DataFlowInfo dataFlowInfo = this.$c.dataFlowInfo;
                DataFlowValue dataFlowValue = this.dataFlowValue;
                Intrinsics.checkExpressionValueIsNotNull(dataFlowValue, "dataFlowValue");
                return dataFlowInfo.getCollectedTypes(dataFlowValue);
            }

            @NotNull
            public String getPresentableText() {
                String string = StringUtil.trimMiddle(this.$expression.getText(), 50);
                Intrinsics.checkExpressionValueIsNotNull(string, "StringUtil.trimMiddle(expression.text, 50)");
                return string;
            }
            {
                this.$c = $captured_local_variable$0;
                this.$expression = $captured_local_variable$1;
                this.$expressionType = $captured_local_variable$2;
                this.dataFlowValue = DataFlowValueFactory.createDataFlowValue($captured_local_variable$1, $captured_local_variable$2, $captured_local_variable$0);
            }
        });
        if (assertionInfo2 != null) {
            c.trace.record(BindingContextSlicesKt.getRUNTIME_ASSERTION_INFO(), expression, assertionInfo2);
        }
    }

    @Override
    public void checkReceiver(@NotNull ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument, boolean safeAccess, @NotNull CallResolutionContext<?> c) {
        Intrinsics.checkParameterIsNotNull(receiverParameter, "receiverParameter");
        Intrinsics.checkParameterIsNotNull(receiverArgument, "receiverArgument");
        Intrinsics.checkParameterIsNotNull(c, "c");
    }

    private RuntimeAssertionsTypeChecker() {
        INSTANCE = this;
    }

    static {
        new RuntimeAssertionsTypeChecker();
    }
}

