/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.model;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.DataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

public abstract class DelegatingResolvedCall<D extends CallableDescriptor>
implements ResolvedCall<D> {
    private final ResolvedCall<? extends D> resolvedCall;

    public DelegatingResolvedCall(@NotNull ResolvedCall<? extends D> resolvedCall2) {
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/resolve/calls/model/DelegatingResolvedCall", "<init>"));
        }
        this.resolvedCall = resolvedCall2;
    }

    @Override
    @NotNull
    public ResolutionStatus getStatus() {
        ResolutionStatus resolutionStatus = this.resolvedCall.getStatus();
        if (resolutionStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/DelegatingResolvedCall", "getStatus"));
        }
        return resolutionStatus;
    }

    @Override
    @NotNull
    public Call getCall() {
        Call call = this.resolvedCall.getCall();
        if (call == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/DelegatingResolvedCall", "getCall"));
        }
        return call;
    }

    @Override
    @NotNull
    public D getCandidateDescriptor() {
        D d = this.resolvedCall.getCandidateDescriptor();
        if (d == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/DelegatingResolvedCall", "getCandidateDescriptor"));
        }
        return d;
    }

    @Override
    @NotNull
    public D getResultingDescriptor() {
        D d = this.resolvedCall.getResultingDescriptor();
        if (d == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/DelegatingResolvedCall", "getResultingDescriptor"));
        }
        return d;
    }

    @Override
    @Nullable
    public Receiver getExtensionReceiver() {
        return this.resolvedCall.getExtensionReceiver();
    }

    @Override
    @Nullable
    public ReceiverValue getDispatchReceiver() {
        return this.resolvedCall.getDispatchReceiver();
    }

    @Override
    @NotNull
    public ExplicitReceiverKind getExplicitReceiverKind() {
        ExplicitReceiverKind explicitReceiverKind = this.resolvedCall.getExplicitReceiverKind();
        if (explicitReceiverKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/DelegatingResolvedCall", "getExplicitReceiverKind"));
        }
        return explicitReceiverKind;
    }

    @Override
    @NotNull
    public Map<ValueParameterDescriptor, ResolvedValueArgument> getValueArguments() {
        Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = this.resolvedCall.getValueArguments();
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/DelegatingResolvedCall", "getValueArguments"));
        }
        return map2;
    }

    @Override
    @NotNull
    public ArgumentMapping getArgumentMapping(@NotNull ValueArgument valueArgument) {
        if (valueArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArgument", "org/jetbrains/kotlin/resolve/calls/model/DelegatingResolvedCall", "getArgumentMapping"));
        }
        ArgumentMapping argumentMapping = this.resolvedCall.getArgumentMapping(valueArgument);
        if (argumentMapping == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/DelegatingResolvedCall", "getArgumentMapping"));
        }
        return argumentMapping;
    }

    @Override
    @Nullable
    public List<ResolvedValueArgument> getValueArgumentsByIndex() {
        return this.resolvedCall.getValueArgumentsByIndex();
    }

    @Override
    @NotNull
    public Map<TypeParameterDescriptor, KotlinType> getTypeArguments() {
        Map<TypeParameterDescriptor, KotlinType> map2 = this.resolvedCall.getTypeArguments();
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/DelegatingResolvedCall", "getTypeArguments"));
        }
        return map2;
    }

    @Override
    @NotNull
    public DataFlowInfoForArguments getDataFlowInfoForArguments() {
        DataFlowInfoForArguments dataFlowInfoForArguments = this.resolvedCall.getDataFlowInfoForArguments();
        if (dataFlowInfoForArguments == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/DelegatingResolvedCall", "getDataFlowInfoForArguments"));
        }
        return dataFlowInfoForArguments;
    }

    @Override
    public boolean isSafeCall() {
        return this.resolvedCall.isSafeCall();
    }

    @Override
    @Nullable
    public KotlinType getSmartCastDispatchReceiverType() {
        return this.resolvedCall.getSmartCastDispatchReceiverType();
    }
}

