/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.checkers.ProtectedInSuperClassCompanionCallChecker$check$;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/ProtectedInSuperClassCompanionCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "F", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "kotlin-compiler"})
public final class ProtectedInSuperClassCompanionCallChecker
implements CallChecker {
    @Override
    public <F extends CallableDescriptor> void check(@NotNull ResolvedCall<F> resolvedCall2, @NotNull BasicCallResolutionContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context, "context");
        CallableDescriptor targetDescriptor = resolvedCall2.getResultingDescriptor().getOriginal();
        if (Intrinsics.areEqual(targetDescriptor.getVisibility(), Visibilities.PROTECTED) ^ true) {
            return;
        }
        if (AnnotationUtilKt.hasJvmStaticAnnotation(targetDescriptor)) {
            return;
        }
        DeclarationDescriptor containerDescriptor = targetDescriptor.getContainingDeclaration();
        if (containerDescriptor instanceof ClassDescriptor && ((ClassDescriptor)containerDescriptor).isCompanionObject()) {
            boolean bl;
            Sequence parentClassDescriptors;
            ClassDescriptor companionOwnerDescriptor;
            DeclarationDescriptor companionDescriptor;
            block9: {
                Sequence $receiver$iv;
                companionDescriptor = containerDescriptor;
                DeclarationDescriptor declarationDescriptor = ((ClassDescriptor)companionDescriptor).getContainingDeclaration();
                if (!(declarationDescriptor instanceof ClassDescriptor)) {
                    declarationDescriptor = null;
                }
                ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
                if (classDescriptor == null) {
                    return;
                }
                companionOwnerDescriptor = classDescriptor;
                Sequence<DeclarationDescriptor> sequence2 = DescriptorUtilsKt.getParentsWithSelf(context.scope.getOwnerDescriptor());
                Sequence sequence3 = SequencesKt.filter($receiver$iv, check$$inlined$filterIsInstance$1.INSTANCE);
                if (sequence3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
                }
                $receiver$iv = parentClassDescriptors = sequence3;
                Iterator iterator2 = $receiver$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv = iterator2.next();
                    ClassDescriptor it = (ClassDescriptor)element$iv;
                    if (!DescriptorUtils.isSubclass(it, companionOwnerDescriptor)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
            if (!bl) {
                return;
            }
            DeclarationDescriptor declarationDescriptor = companionDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "companionDescriptor");
            if (SequencesKt.contains(parentClassDescriptors, declarationDescriptor) ^ true && SequencesKt.contains(parentClassDescriptors, companionOwnerDescriptor) ^ true) {
                context.trace.report(ErrorsJvm.SUBCLASS_CANT_CALL_COMPANION_PROTECTED_NON_STATIC.on((KtElement)((PsiElement)resolvedCall2.getCall().getCallElement())));
            }
        }
    }
}

