/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.Sets;
import com.intellij.psi.tree.IElementType;
import java.util.HashSet;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.context.CallPosition;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.BasicExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingVisitor;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.FunctionsTypingVisitor;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.expressions.PatternMatchingTypingVisitor;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

public class ExpressionTypingVisitorForStatements
extends ExpressionTypingVisitor {
    private final LexicalWritableScope scope;
    private final BasicExpressionTypingVisitor basic;
    private final ControlStructureTypingVisitor controlStructures;
    private final PatternMatchingTypingVisitor patterns;
    private final FunctionsTypingVisitor functions;

    public ExpressionTypingVisitorForStatements(@NotNull ExpressionTypingInternals facade, @NotNull LexicalWritableScope scope2, @NotNull BasicExpressionTypingVisitor basic, @NotNull ControlStructureTypingVisitor controlStructures, @NotNull PatternMatchingTypingVisitor patterns, @NotNull FunctionsTypingVisitor functions2) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "<init>"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "<init>"));
        }
        if (basic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basic", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "<init>"));
        }
        if (controlStructures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controlStructures", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "<init>"));
        }
        if (patterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "<init>"));
        }
        if (functions2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functions", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "<init>"));
        }
        super(facade);
        this.scope = scope2;
        this.basic = basic;
        this.controlStructures = controlStructures;
        this.patterns = patterns;
        this.functions = functions2;
    }

    @Nullable
    private KotlinType checkAssignmentType(@Nullable KotlinType assignmentType, @NotNull KtBinaryExpression expression, @NotNull ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "checkAssignmentType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "checkAssignmentType"));
        }
        if (assignmentType != null && !KotlinBuiltIns.isUnit(assignmentType) && !TypeUtils.noExpectedType(context.expectedType) && !context.expectedType.isError() && TypeUtils.equalTypes(context.expectedType, assignmentType)) {
            context.trace.report(Errors.ASSIGNMENT_TYPE_MISMATCH.on(expression, context.expectedType));
            return null;
        }
        return this.components.dataFlowAnalyzer.checkStatementType(expression, context);
    }

    @Override
    public KotlinTypeInfo visitObjectDeclaration(@NotNull KtObjectDeclaration declaration, ExpressionTypingContext context) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitObjectDeclaration"));
        }
        this.components.localClassifierAnalyzer.processClassOrObject(this.scope, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceScope(this.scope)).replaceContextDependency(ContextDependency.INDEPENDENT), this.scope.getOwnerDescriptor(), declaration);
        return TypeInfoFactoryKt.createTypeInfo(this.components.dataFlowAnalyzer.checkStatementType(declaration, context), context);
    }

    @Override
    public KotlinTypeInfo visitProperty(@NotNull KtProperty property, ExpressionTypingContext typingContext) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitProperty"));
        }
        Pair<KotlinTypeInfo, VariableDescriptor> typeInfoAndVariableDescriptor = this.components.localVariableResolver.process(property, typingContext, this.scope, this.facade);
        this.scope.addVariableDescriptor(typeInfoAndVariableDescriptor.getSecond());
        return typeInfoAndVariableDescriptor.getFirst();
    }

    @Override
    public KotlinTypeInfo visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration multiDeclaration, ExpressionTypingContext context) {
        if (multiDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiDeclaration", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitDestructuringDeclaration"));
        }
        this.components.annotationResolver.resolveAnnotationsWithArguments((LexicalScope)this.scope, multiDeclaration.getModifierList(), context.trace);
        KtExpression initializer2 = multiDeclaration.getInitializer();
        if (initializer2 == null) {
            context.trace.report(Errors.INITIALIZER_REQUIRED_FOR_DESTRUCTURING_DECLARATION.on(multiDeclaration));
        }
        ExpressionReceiver expressionReceiver = initializer2 != null ? ExpressionTypingUtils.getExpressionReceiver(this.facade, initializer2, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT)) : null;
        this.components.destructuringDeclarationResolver.defineLocalVariablesFromMultiDeclaration(this.scope, multiDeclaration, expressionReceiver, initializer2, context);
        this.components.modifiersChecker.withTrace(context.trace).checkModifiersForDestructuringDeclaration(multiDeclaration);
        this.components.identifierChecker.checkDeclaration(multiDeclaration, context.trace);
        if (expressionReceiver == null) {
            return TypeInfoFactoryKt.noTypeInfo(context);
        }
        return this.facade.getTypeInfo(initializer2, context).replaceType(this.components.dataFlowAnalyzer.checkStatementType(multiDeclaration, context));
    }

    @Override
    public KotlinTypeInfo visitNamedFunction(@NotNull KtNamedFunction function, ExpressionTypingContext context) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitNamedFunction"));
        }
        return this.functions.visitNamedFunction(function, context, true, this.scope);
    }

    @Override
    public KotlinTypeInfo visitClass(@NotNull KtClass klass, ExpressionTypingContext context) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitClass"));
        }
        this.components.localClassifierAnalyzer.processClassOrObject(this.scope, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceScope(this.scope)).replaceContextDependency(ContextDependency.INDEPENDENT), this.scope.getOwnerDescriptor(), klass);
        return TypeInfoFactoryKt.createTypeInfo(this.components.dataFlowAnalyzer.checkStatementType(klass, context), context);
    }

    @Override
    public KotlinTypeInfo visitDeclaration(@NotNull KtDeclaration dcl, ExpressionTypingContext context) {
        if (dcl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dcl", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitDeclaration"));
        }
        return TypeInfoFactoryKt.createTypeInfo(this.components.dataFlowAnalyzer.checkStatementType(dcl, context), context);
    }

    @Override
    public KotlinTypeInfo visitBinaryExpression(@NotNull KtBinaryExpression expression, ExpressionTypingContext context) {
        KotlinTypeInfo result2;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitBinaryExpression"));
        }
        KtSimpleNameExpression operationSign = expression.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType == KtTokens.EQ) {
            result2 = this.visitAssignment(expression, context);
        } else if (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(operationType)) {
            result2 = this.visitAssignmentOperation(expression, context);
        } else {
            return this.facade.getTypeInfo(expression, context);
        }
        return this.components.dataFlowAnalyzer.checkType(result2, (KtExpression)expression, (ResolutionContext)context);
    }

    @NotNull
    protected KotlinTypeInfo visitAssignmentOperation(KtBinaryExpression expression, ExpressionTypingContext contextWithExpectedType) {
        KotlinType binaryOperationType;
        OverloadResolutionResults<Object> binaryOperationDescriptors;
        KtExpression left;
        TemporaryTraceAndCache temporary = TemporaryTraceAndCache.create(contextWithExpectedType, "trace to resolve array set method for binary expression", expression);
        ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceTraceAndCache(temporary)).replaceContextDependency(ContextDependency.INDEPENDENT);
        KtSimpleNameExpression operationSign = expression.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        KtExpression leftOperand = expression.getLeft();
        KotlinTypeInfo leftInfo = ExpressionTypingUtils.getTypeInfoOrNullType(leftOperand, context, this.facade);
        KotlinType leftType = leftInfo.getType();
        KtExpression right = expression.getRight();
        KtExpression ktExpression = left = leftOperand == null ? null : KtPsiUtil.deparenthesize(leftOperand);
        if (right == null || left == null) {
            temporary.commit();
            KotlinTypeInfo kotlinTypeInfo = leftInfo.clearType();
            if (kotlinTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitAssignmentOperation"));
            }
            return kotlinTypeInfo;
        }
        if (leftType == null) {
            KotlinTypeInfo rightInfo = this.facade.getTypeInfo(right, (ExpressionTypingContext)context.replaceDataFlowInfo(leftInfo.getDataFlowInfo()));
            context.trace.report(Errors.UNRESOLVED_REFERENCE.on(operationSign, operationSign));
            temporary.commit();
            KotlinTypeInfo kotlinTypeInfo = rightInfo.clearType();
            if (kotlinTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitAssignmentOperation"));
            }
            return kotlinTypeInfo;
        }
        ExpressionReceiver receiver = ExpressionReceiver.Companion.create(left, leftType, context.trace.getBindingContext());
        Name name = (Name)OperatorConventions.ASSIGNMENT_OPERATIONS.get(operationType);
        TemporaryTraceAndCache temporaryForAssignmentOperation = TemporaryTraceAndCache.create(context, "trace to check assignment operation like '+=' for", expression);
        OverloadResolutionResults<FunctionDescriptor> assignmentOperationDescriptors = this.components.callResolver.resolveBinaryCall((ExpressionTypingContext)((ExpressionTypingContext)context.replaceTraceAndCache(temporaryForAssignmentOperation)).replaceScope(this.scope), receiver, expression, name);
        KotlinType assignmentOperationType = OverloadResolutionResultsUtil.getResultingType(assignmentOperationDescriptors, context.contextDependency);
        TemporaryTraceAndCache temporaryForBinaryOperation = TemporaryTraceAndCache.create(context, "trace to check binary operation like '+' for", expression);
        TemporaryBindingTrace ignoreReportsTrace = TemporaryBindingTrace.create(context.trace, "Trace for checking assignability");
        boolean lhsAssignable = this.basic.checkLValue(ignoreReportsTrace, context, left, right);
        if (assignmentOperationType == null || lhsAssignable) {
            Name counterpartName = (Name)OperatorConventions.BINARY_OPERATION_NAMES.get(OperatorConventions.ASSIGNMENT_OPERATION_COUNTERPARTS.get(operationType));
            binaryOperationDescriptors = this.components.callResolver.resolveBinaryCall((ExpressionTypingContext)((ExpressionTypingContext)context.replaceTraceAndCache(temporaryForBinaryOperation)).replaceScope(this.scope), receiver, expression, counterpartName);
            binaryOperationType = OverloadResolutionResultsUtil.getResultingType(binaryOperationDescriptors, context.contextDependency);
        } else {
            binaryOperationDescriptors = OverloadResolutionResultsImpl.nameNotFound();
            binaryOperationType = null;
        }
        KotlinType type2 = assignmentOperationType != null ? assignmentOperationType : binaryOperationType;
        KotlinTypeInfo rightInfo = leftInfo;
        if (assignmentOperationDescriptors.isSuccess() && binaryOperationDescriptors.isSuccess()) {
            OverloadResolutionResults<FunctionDescriptor> ambiguityResolutionResults = OverloadResolutionResultsUtil.ambiguity(assignmentOperationDescriptors, binaryOperationDescriptors);
            context.trace.report(Errors.ASSIGN_OPERATOR_AMBIGUITY.on(operationSign, ambiguityResolutionResults.getResultingCalls()));
            HashSet<FunctionDescriptor> descriptors = Sets.newHashSet();
            for (ResolvedCall<FunctionDescriptor> resolvedCall2 : ambiguityResolutionResults.getResultingCalls()) {
                descriptors.add(resolvedCall2.getResultingDescriptor());
            }
            rightInfo = this.facade.getTypeInfo(right, (ExpressionTypingContext)context.replaceDataFlowInfo(leftInfo.getDataFlowInfo()));
            context.trace.record(BindingContext.AMBIGUOUS_REFERENCE_TARGET, operationSign, descriptors);
        } else if (assignmentOperationType != null && (assignmentOperationDescriptors.isSuccess() || !binaryOperationDescriptors.isSuccess())) {
            temporaryForAssignmentOperation.commit();
            if (!KotlinTypeChecker.DEFAULT.equalTypes(this.components.builtIns.getUnitType(), assignmentOperationType)) {
                context.trace.report(Errors.ASSIGNMENT_OPERATOR_SHOULD_RETURN_UNIT.on(operationSign, assignmentOperationDescriptors.getResultingDescriptor(), operationSign));
            }
        } else {
            temporaryForBinaryOperation.commit();
            context.trace.record(BindingContext.VARIABLE_REASSIGNMENT, expression);
            if (left instanceof KtArrayAccessExpression) {
                ExpressionTypingContext contextForResolve = (ExpressionTypingContext)((ExpressionTypingContext)context.replaceScope(this.scope)).replaceBindingTrace(TemporaryBindingTrace.create(context.trace, "trace to resolve array set method for assignment", expression));
                this.basic.resolveImplicitArrayAccessSetMethod((KtArrayAccessExpression)left, right, contextForResolve, context.trace);
            }
            rightInfo = this.facade.getTypeInfo(right, (ExpressionTypingContext)context.replaceDataFlowInfo(leftInfo.getDataFlowInfo()));
            KotlinType expectedType = ExpressionTypingVisitorForStatements.refineTypeFromPropertySetterIfPossible(context.trace.getBindingContext(), leftOperand, leftType);
            this.components.dataFlowAnalyzer.checkType(binaryOperationType, (KtExpression)expression, (ResolutionContext)((ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(expectedType)).replaceDataFlowInfo(rightInfo.getDataFlowInfo())).replaceCallPosition(new CallPosition.PropertyAssignment(left)));
            this.basic.checkLValue(context.trace, context, leftOperand, right);
        }
        temporary.commit();
        KotlinTypeInfo kotlinTypeInfo = rightInfo.replaceType(this.checkAssignmentType(type2, expression, contextWithExpectedType));
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitAssignmentOperation"));
        }
        return kotlinTypeInfo;
    }

    @Nullable
    private static KotlinType refineTypeFromPropertySetterIfPossible(@NotNull BindingContext bindingContext, @Nullable KtElement leftOperand, @Nullable KotlinType leftOperandType) {
        PropertySetterDescriptor setter;
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "refineTypeFromPropertySetterIfPossible"));
        }
        VariableDescriptor descriptor2 = BindingContextUtils.extractVariableFromResolvedCall(bindingContext, leftOperand);
        if (descriptor2 instanceof PropertyDescriptor && (setter = ((PropertyDescriptor)descriptor2).getSetter()) != null) {
            return setter.getValueParameters().get(0).getType();
        }
        return leftOperandType;
    }

    @NotNull
    protected KotlinTypeInfo visitAssignment(KtBinaryExpression expression, ExpressionTypingContext contextWithExpectedType) {
        KotlinTypeInfo resultInfo;
        ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceScope(this.scope)).replaceContextDependency(ContextDependency.INDEPENDENT);
        KtExpression leftOperand = expression.getLeft();
        if (leftOperand instanceof KtAnnotatedExpression) {
            this.components.annotationResolver.resolveAnnotationsWithArguments((LexicalScope)this.scope, ((KtAnnotatedExpression)leftOperand).getAnnotationEntries(), context.trace);
        }
        KtExpression left = KtPsiUtil.deparenthesize(leftOperand);
        KtExpression right = expression.getRight();
        if (left instanceof KtArrayAccessExpression) {
            KtArrayAccessExpression arrayAccessExpression = (KtArrayAccessExpression)left;
            if (right == null) {
                KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
                if (kotlinTypeInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitAssignment"));
                }
                return kotlinTypeInfo;
            }
            KotlinTypeInfo typeInfo = this.basic.resolveArrayAccessSetMethod(arrayAccessExpression, right, context, context.trace);
            this.basic.checkLValue(context.trace, context, arrayAccessExpression, right);
            KotlinTypeInfo kotlinTypeInfo = typeInfo.replaceType(this.checkAssignmentType(typeInfo.getType(), expression, contextWithExpectedType));
            if (kotlinTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitAssignment"));
            }
            return kotlinTypeInfo;
        }
        KotlinTypeInfo leftInfo = ExpressionTypingUtils.getTypeInfoOrNullType(left, context, this.facade);
        KotlinType expectedType = ExpressionTypingVisitorForStatements.refineTypeFromPropertySetterIfPossible(context.trace.getBindingContext(), leftOperand, leftInfo.getType());
        DataFlowInfo dataFlowInfo = leftInfo.getDataFlowInfo();
        if (right != null) {
            resultInfo = this.facade.getTypeInfo(right, (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context.replaceDataFlowInfo(dataFlowInfo)).replaceExpectedType(expectedType)).replaceCallPosition(new CallPosition.PropertyAssignment(leftOperand)));
            dataFlowInfo = resultInfo.getDataFlowInfo();
            KotlinType rightType = resultInfo.getType();
            if (left != null && expectedType != null && rightType != null) {
                DataFlowValue leftValue = DataFlowValueFactory.createDataFlowValue(left, expectedType, context);
                DataFlowValue rightValue = DataFlowValueFactory.createDataFlowValue(right, rightType, context);
                resultInfo = resultInfo.replaceDataFlowInfo(dataFlowInfo.assign(leftValue, rightValue));
            }
        } else {
            resultInfo = leftInfo;
        }
        if (expectedType != null && leftOperand != null) {
            this.basic.checkLValue(context.trace, context, leftOperand, right);
        }
        KotlinTypeInfo kotlinTypeInfo = resultInfo.replaceType(this.components.dataFlowAnalyzer.checkStatementType(expression, contextWithExpectedType));
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitAssignment"));
        }
        return kotlinTypeInfo;
    }

    @Override
    public KotlinTypeInfo visitExpression(@NotNull KtExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitExpression"));
        }
        return this.facade.getTypeInfo(expression, context);
    }

    @Override
    public KotlinTypeInfo visitKtElement(@NotNull KtElement element, ExpressionTypingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitKtElement"));
        }
        context.trace.report(Errors.UNSUPPORTED.on(element, "in a block"));
        return TypeInfoFactoryKt.noTypeInfo(context);
    }

    @Override
    public KotlinTypeInfo visitWhileExpression(@NotNull KtWhileExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitWhileExpression"));
        }
        return this.controlStructures.visitWhileExpression(expression, context, true);
    }

    @Override
    public KotlinTypeInfo visitDoWhileExpression(@NotNull KtDoWhileExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitDoWhileExpression"));
        }
        return this.controlStructures.visitDoWhileExpression(expression, context, true);
    }

    @Override
    public KotlinTypeInfo visitForExpression(@NotNull KtForExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitForExpression"));
        }
        return this.controlStructures.visitForExpression(expression, context, true);
    }

    @Override
    public KotlinTypeInfo visitAnnotatedExpression(@NotNull KtAnnotatedExpression expression, ExpressionTypingContext data) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitAnnotatedExpression"));
        }
        return this.basic.visitAnnotatedExpression(expression, data, true);
    }

    @Override
    public KotlinTypeInfo visitIfExpression(@NotNull KtIfExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitIfExpression"));
        }
        return this.controlStructures.visitIfExpression(expression, context, true);
    }

    @Override
    public KotlinTypeInfo visitWhenExpression(@NotNull KtWhenExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitWhenExpression"));
        }
        return this.patterns.visitWhenExpression(expression, context, true);
    }

    @Override
    public KotlinTypeInfo visitBlockExpression(@NotNull KtBlockExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitBlockExpression"));
        }
        return this.components.expressionTypingServices.getBlockReturnedType(expression, context, true);
    }

    @Override
    public KotlinTypeInfo visitLabeledExpression(@NotNull KtLabeledExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitLabeledExpression"));
        }
        return this.basic.visitLabeledExpression(expression, context, true);
    }
}

