/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.gradle.api.Action;
import org.gradle.execution.CancellableOperationManager;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.UncheckedException;
import org.gradle.util.DisconnectableInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCancellableOperationManager
implements CancellableOperationManager {
    private static final int EOF = -1;
    private static final int KEY_CODE_CTRL_D = 4;
    private final ExecutorService executorService;
    private final DisconnectableInputStream input;
    private final BuildCancellationToken cancellationToken;

    public DefaultCancellableOperationManager(ExecutorService executorService, DisconnectableInputStream input, BuildCancellationToken cancellationToken) {
        this.executorService = executorService;
        this.input = input;
        this.cancellationToken = cancellationToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitorInput(Action<? super BuildCancellationToken> operation) {
        Future<?> handle = null;
        try {
            handle = this.executorService.submit(new Runnable(){

                public void run() {
                    try {
                        while (!Thread.currentThread().isInterrupted()) {
                            int c = DefaultCancellableOperationManager.this.input.read();
                            if (c != 4 && c != -1) continue;
                            DefaultCancellableOperationManager.this.cancellationToken.cancel();
                            break;
                        }
                    }
                    catch (IOException e) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    }
                }
            });
            operation.execute((Object)this.cancellationToken);
        }
        finally {
            if (handle != null) {
                handle.cancel(true);
            }
        }
    }
}

