/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.text;

import org.gradle.logging.internal.AbstractStyledTextOutput;
import org.gradle.logging.internal.LinePrefixingStyledTextOutput;
import org.gradle.util.TreeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeFormatter
extends TreeVisitor<String> {
    private final StringBuilder buffer = new StringBuilder();
    private final AbstractStyledTextOutput original = new AbstractStyledTextOutput(){

        protected void doAppend(String text) {
            TreeFormatter.this.buffer.append(text);
        }
    };
    private Node current = new Node();

    public String toString() {
        return this.buffer.toString();
    }

    @Override
    public void node(String node) {
        if (this.current.traversing) {
            this.current = new Node(this.current, node);
            if (this.current.isRoot()) {
                this.original.append(node);
                this.current.valueWritten = true;
            }
        } else {
            this.current = new Node(this.current.parent, node);
        }
    }

    @Override
    public void startChildren() {
        this.current.traversing = true;
    }

    @Override
    public void endChildren() {
        if (this.current.parent == null) {
            throw new IllegalStateException("Not visiting any node.");
        }
        if (!this.current.traversing) {
            this.current = this.current.parent;
        }
        if (this.current.isRoot()) {
            this.writeNode(this.current);
        }
        this.current = this.current.parent;
    }

    private void writeNode(Node node) {
        if (node.prefix == null) {
            node.prefix = node.isRoot() ? "" : node.parent.prefix + "    ";
        }
        LinePrefixingStyledTextOutput output = new LinePrefixingStyledTextOutput(this.original, node.prefix, false);
        if (!node.valueWritten) {
            output.append(node.parent.prefix);
            output.append("  - ");
            output.append(node.value);
        }
        if (node.canCollapseFirstChild()) {
            output.append(": ");
            Node firstChild = node.firstChild;
            output.append(firstChild.value);
            firstChild.valueWritten = true;
            firstChild.prefix = node.prefix;
            this.writeNode(firstChild);
        } else if (node.firstChild != null) {
            this.original.format(":%n", new Object[0]);
            this.writeNode(node.firstChild);
        }
        if (node.nextSibling != null) {
            this.original.format("%n", new Object[0]);
            this.writeNode(node.nextSibling);
        }
    }

    private static class Node {
        final Node parent;
        final String value;
        boolean written;
        boolean traversing;
        Node firstChild;
        Node lastChild;
        Node nextSibling;
        String prefix;
        public boolean valueWritten;

        private Node() {
            this.parent = null;
            this.value = null;
            this.traversing = true;
            this.written = true;
            this.prefix = "";
        }

        private Node(Node parent, String value) {
            this.parent = parent;
            this.value = value;
            if (parent.firstChild == null) {
                parent.firstChild = this;
                parent.lastChild = this;
            } else {
                parent.lastChild.nextSibling = this;
                parent.lastChild = this;
            }
        }

        boolean canCollapseFirstChild() {
            return this.firstChild != null && this.firstChild.nextSibling == null && !this.firstChild.canCollapseFirstChild();
        }

        boolean isRoot() {
            return this.parent.parent == null;
        }
    }
}

