/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import org.intellij.plugins.xsltDebugger.DebuggerConnector;
import org.intellij.plugins.xsltDebugger.VMPausedException;
import org.intellij.plugins.xsltDebugger.XsltDebuggerSession;
import org.intellij.plugins.xsltDebugger.rt.engine.DebuggerStoppedException;

class DebugProcessListener
extends ProcessAdapter {
    private final Project myProject;
    private final int myPort;

    public DebugProcessListener(Project project, int port) {
        this.myProject = project;
        this.myPort = port;
    }

    public void startNotified(ProcessEvent event) {
        DebuggerConnector connector = new DebuggerConnector(this.myProject, event.getProcessHandler(), this.myPort);
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)connector);
    }

    public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
        try {
            XsltDebuggerSession session = XsltDebuggerSession.getInstance(event.getProcessHandler());
            if (session != null) {
                session.stop();
            }
        }
        catch (VMPausedException vMPausedException) {
        }
        catch (DebuggerStoppedException debuggerStoppedException) {
            // empty catch block
        }
        super.processWillTerminate(event, willBeDestroyed);
    }

    public void processTerminated(ProcessEvent event) {
        super.processTerminated(event);
        XsltDebuggerSession session = XsltDebuggerSession.getInstance(event.getProcessHandler());
        if (session != null) {
            session.close();
        }
    }
}

