/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.LocalTimeCounter;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import org.intellij.lang.xpath.XPathFileType;
import org.intellij.lang.xpath.xslt.impl.XsltChecker;
import org.intellij.plugins.xsltDebugger.BreakpointContext;
import org.intellij.plugins.xsltDebugger.impl.EvalContextProvider;
import org.intellij.plugins.xsltDebugger.impl.XsltBreakpointHandler;
import org.intellij.plugins.xsltDebugger.impl.XsltSourcePosition;
import org.intellij.plugins.xsltDebugger.rt.engine.Debugger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XsltDebuggerEditorsProvider
extends XDebuggerEditorsProvider {
    private final XPathFileType myFileType;

    public XsltDebuggerEditorsProvider(XsltChecker.LanguageLevel level) {
        this.myFileType = level == XsltChecker.LanguageLevel.V2 ? XPathFileType.XPATH2 : XPathFileType.XPATH;
    }

    @NotNull
    public FileType getFileType() {
        XPathFileType xPathFileType = this.myFileType;
        if (xPathFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xsltDebugger/impl/XsltDebuggerEditorsProvider", "getFileType"));
        }
        return xPathFileType;
    }

    @NotNull
    public Document createDocument(@NotNull Project project, @NotNull String text, @Nullable XSourcePosition sourcePosition, @NotNull EvaluationMode mode) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/xsltDebugger/impl/XsltDebuggerEditorsProvider", "createDocument"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/intellij/plugins/xsltDebugger/impl/XsltDebuggerEditorsProvider", "createDocument"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/intellij/plugins/xsltDebugger/impl/XsltDebuggerEditorsProvider", "createDocument"));
        }
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("XPathExpr." + this.myFileType.getDefaultExtension(), (FileType)this.myFileType, (CharSequence)text, LocalTimeCounter.currentTime(), true);
        if (sourcePosition instanceof XsltSourcePosition && ((XsltSourcePosition)sourcePosition).getLocation() instanceof Debugger.StyleFrame) {
            Debugger.Locatable location = ((XsltSourcePosition)sourcePosition).getLocation();
            EvalContextProvider context = new EvalContextProvider(((Debugger.StyleFrame)location).getVariables());
            context.attachTo(psiFile);
        } else {
            PsiElement contextElement = XsltBreakpointHandler.findContextElement(project, sourcePosition);
            if (contextElement != null) {
                BreakpointContext context = new BreakpointContext(contextElement);
                context.attachTo(psiFile);
            }
        }
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        assert (document != null);
        Document document2 = document;
        if (document2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xsltDebugger/impl/XsltDebuggerEditorsProvider", "createDocument"));
        }
        return document2;
    }
}

