/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.impl;

import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import java.util.ArrayList;
import java.util.Collections;
import org.intellij.plugins.xsltDebugger.VMPausedException;
import org.intellij.plugins.xsltDebugger.XsltDebuggerSession;
import org.intellij.plugins.xsltDebugger.impl.XsltStackFrame;
import org.intellij.plugins.xsltDebugger.rt.engine.Debugger;

public class XsltExecutionStack
extends XExecutionStack {
    private final XsltStackFrame myTopFrame;
    private final XsltDebuggerSession myDebuggerSession;

    public XsltExecutionStack(String name, Debugger.Frame topFrame, XsltDebuggerSession debuggerSession) {
        super(name);
        this.myDebuggerSession = debuggerSession;
        this.myTopFrame = new XsltStackFrame(topFrame, this.myDebuggerSession);
    }

    public XStackFrame getTopFrame() {
        return this.myTopFrame;
    }

    public void computeStackFrames(int firstFrameIndex, XExecutionStack.XStackFrameContainer container) {
        try {
            if (this.myDebuggerSession.getCurrentState() == Debugger.State.SUSPENDED) {
                Debugger.Frame frame = this.myTopFrame.getFrame();
                ArrayList<XsltStackFrame> frames = new ArrayList<XsltStackFrame>();
                frames.add(this.myTopFrame);
                while (frame != null) {
                    if ((frame = frame.getPrevious()) == null) continue;
                    frames.add(new XsltStackFrame(frame, this.myDebuggerSession));
                }
                if (firstFrameIndex <= frames.size()) {
                    container.addStackFrames(frames.subList(firstFrameIndex, frames.size()), true);
                } else {
                    container.addStackFrames(Collections.emptyList(), true);
                }
            }
        }
        catch (VMPausedException e) {
            container.errorOccurred("Target VM is not responding");
        }
    }
}

