/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CompletionInitializationContext {
    public static final OffsetKey START_OFFSET = OffsetKey.create("startOffset", false);
    public static final OffsetKey SELECTION_END_OFFSET = OffsetKey.create("selectionEnd");
    public static final OffsetKey IDENTIFIER_END_OFFSET = OffsetKey.create("identifierEnd");
    @NonNls
    public static final String DUMMY_IDENTIFIER = "IntellijIdeaRulezzz ";
    @NonNls
    public static final String DUMMY_IDENTIFIER_TRIMMED = "IntellijIdeaRulezzz";
    private final Editor myEditor;
    @NotNull
    private final Caret myCaret;
    private final PsiFile myFile;
    private final CompletionType myCompletionType;
    private final int myInvocationCount;
    private final OffsetMap myOffsetMap;
    private String myDummyIdentifier;

    public CompletionInitializationContext(Editor editor, @NotNull Caret caret, PsiFile file, CompletionType completionType, int invocationCount) {
        if (caret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/codeInsight/completion/CompletionInitializationContext", "<init>"));
        }
        this.myDummyIdentifier = DUMMY_IDENTIFIER;
        this.myEditor = editor;
        this.myCaret = caret;
        this.myFile = file;
        this.myCompletionType = completionType;
        this.myInvocationCount = invocationCount;
        this.myOffsetMap = new OffsetMap(editor.getDocument());
        this.myOffsetMap.addOffset(START_OFFSET, CompletionInitializationContext.calcStartOffset(caret));
        this.myOffsetMap.addOffset(SELECTION_END_OFFSET, CompletionInitializationContext.calcSelectionEnd(caret));
        this.myOffsetMap.addOffset(IDENTIFIER_END_OFFSET, CompletionInitializationContext.calcDefaultIdentifierEnd(editor, CompletionInitializationContext.calcSelectionEnd(caret)));
    }

    private static int calcSelectionEnd(Caret caret) {
        return caret.hasSelection() ? caret.getSelectionEnd() : caret.getOffset();
    }

    public static int calcStartOffset(Caret caret) {
        return caret.hasSelection() ? caret.getSelectionStart() : caret.getOffset();
    }

    static int calcDefaultIdentifierEnd(Editor editor, int startFrom) {
        int idEnd;
        CharSequence text = editor.getDocument().getCharsSequence();
        for (idEnd = startFrom; idEnd < text.length() && Character.isJavaIdentifierPart(text.charAt(idEnd)); ++idEnd) {
        }
        return idEnd;
    }

    public void setDummyIdentifier(@NotNull String dummyIdentifier) {
        if (dummyIdentifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dummyIdentifier", "com/intellij/codeInsight/completion/CompletionInitializationContext", "setDummyIdentifier"));
        }
        this.myDummyIdentifier = dummyIdentifier;
    }

    @NotNull
    public Language getPositionLanguage() {
        Language language = (Language)((Object)ObjectUtils.assertNotNull((Object)((Object)PsiUtilBase.getLanguageInEditor(this.getEditor(), this.getProject()))));
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionInitializationContext", "getPositionLanguage"));
        }
        return language;
    }

    public String getDummyIdentifier() {
        return this.myDummyIdentifier;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionInitializationContext", "getEditor"));
        }
        return editor;
    }

    @NotNull
    public Caret getCaret() {
        Caret caret = this.myCaret;
        if (caret == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionInitializationContext", "getCaret"));
        }
        return caret;
    }

    @NotNull
    public CompletionType getCompletionType() {
        CompletionType completionType = this.myCompletionType;
        if (completionType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionInitializationContext", "getCompletionType"));
        }
        return completionType;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myFile.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionInitializationContext", "getProject"));
        }
        return project;
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionInitializationContext", "getFile"));
        }
        return psiFile;
    }

    @NotNull
    public OffsetMap getOffsetMap() {
        OffsetMap offsetMap = this.myOffsetMap;
        if (offsetMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionInitializationContext", "getOffsetMap"));
        }
        return offsetMap;
    }

    public int getStartOffset() {
        return this.myOffsetMap.getOffset(START_OFFSET);
    }

    public int getSelectionEndOffset() {
        return this.myOffsetMap.getOffset(SELECTION_END_OFFSET);
    }

    public int getIdentifierEndOffset() {
        return this.myOffsetMap.getOffset(IDENTIFIER_END_OFFSET);
    }

    public int getReplacementOffset() {
        return this.getIdentifierEndOffset();
    }

    public int getInvocationCount() {
        return this.myInvocationCount;
    }

    public void setReplacementOffset(int idEnd) {
        this.myOffsetMap.addOffset(IDENTIFIER_END_OFFSET, idEnd);
    }
}

