/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ToolbarDecorator;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellEditor;

public class ListEditForm {
    JPanel contentPanel;
    ListTable table;

    public ListEditForm(String title, List<String> stringList) {
        this.table = new ListTable(new ListWrappingTableModel(stringList, title));
        this.contentPanel = ToolbarDecorator.createDecorator(this.table).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                final ListWrappingTableModel tableModel = ListEditForm.this.table.getModel();
                tableModel.addRow();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int lastRowIndex = tableModel.getRowCount() - 1;
                        Rectangle rectangle = ListEditForm.this.table.getCellRect(lastRowIndex, 0, true);
                        ListEditForm.this.table.scrollRectToVisible(rectangle);
                        ListEditForm.this.table.editCellAt(lastRowIndex, 0);
                        ListSelectionModel selectionModel = ListEditForm.this.table.getSelectionModel();
                        selectionModel.setSelectionInterval(lastRowIndex, lastRowIndex);
                        TableCellEditor editor = ListEditForm.this.table.getCellEditor();
                        Component component = editor.getTableCellEditorComponent(ListEditForm.this.table, null, true, lastRowIndex, 0);
                        component.requestFocus();
                    }
                });
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ListSelectionModel selectionModel = ListEditForm.this.table.getSelectionModel();
                int minIndex = selectionModel.getMinSelectionIndex();
                int maxIndex = selectionModel.getMaxSelectionIndex();
                if (minIndex == -1 || maxIndex == -1) {
                    return;
                }
                ListWrappingTableModel tableModel = ListEditForm.this.table.getModel();
                for (int i = minIndex; i <= maxIndex; ++i) {
                    if (!selectionModel.isSelectedIndex(i)) continue;
                    tableModel.removeRow(i);
                }
                int count = tableModel.getRowCount();
                if (count <= minIndex) {
                    selectionModel.setSelectionInterval(count - 1, count - 1);
                } else if (minIndex <= 0) {
                    if (count > 0) {
                        selectionModel.setSelectionInterval(0, 0);
                    }
                } else {
                    selectionModel.setSelectionInterval(minIndex - 1, minIndex - 1);
                }
            }
        }).disableUpDownActions().createPanel();
    }

    public JComponent getContentPanel() {
        return this.contentPanel;
    }
}

