/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.util.treeView.NodeDescriptor;
import java.util.HashSet;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TreeUpdatePass {
    private final DefaultMutableTreeNode myNode;
    private long myUpdateStamp;
    private boolean myExpired;
    private DefaultMutableTreeNode myCurrentNode;
    private final long myAllocation;
    private boolean myUpdateChildren;
    private boolean myUpdateStructure;
    private final Set<NodeDescriptor> myUpdatedDescriptors;

    public TreeUpdatePass(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/ide/util/treeView/TreeUpdatePass", "<init>"));
        }
        this.myUpdateChildren = true;
        this.myUpdateStructure = true;
        this.myUpdatedDescriptors = new HashSet<NodeDescriptor>();
        this.myNode = node;
        this.myAllocation = System.currentTimeMillis();
    }

    public TreeUpdatePass setUpdateChildren(boolean updateChildren) {
        this.myUpdateChildren = updateChildren;
        return this;
    }

    public boolean isUpdateChildren() {
        return this.myUpdateChildren;
    }

    @NotNull
    public DefaultMutableTreeNode getNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.myNode;
        if (defaultMutableTreeNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/TreeUpdatePass", "getNode"));
        }
        return defaultMutableTreeNode;
    }

    public TreeUpdatePass setUpdateStamp(long updateCount) {
        this.myUpdateStamp = updateCount;
        return this;
    }

    public long getUpdateStamp() {
        return this.myUpdateStamp;
    }

    public void expire() {
        this.myExpired = true;
    }

    public boolean isExpired() {
        return this.myExpired;
    }

    public DefaultMutableTreeNode getCurrentNode() {
        return this.myCurrentNode;
    }

    public void setCurrentNode(DefaultMutableTreeNode currentNode) {
        this.myCurrentNode = currentNode;
    }

    @NonNls
    public String toString() {
        return "TreeUpdatePass node=" + this.myNode + " structure=" + this.myUpdateStructure + " stamp=" + this.myUpdateStamp + " expired=" + this.myExpired + " currentNode=" + this.myCurrentNode + " allocation=" + this.myAllocation;
    }

    public boolean willUpdate(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/ide/util/treeView/TreeUpdatePass", "willUpdate"));
        }
        DefaultMutableTreeNode currentNode = this.myCurrentNode != null ? this.myCurrentNode : this.myNode;
        return node.isNodeAncestor(currentNode);
    }

    public TreeUpdatePass setUpdateStructure(boolean update) {
        this.myUpdateStructure = update;
        return this;
    }

    public boolean isUpdateStructure() {
        return this.myUpdateStructure;
    }

    public void addToUpdated(NodeDescriptor nodeDescriptor) {
        this.myUpdatedDescriptors.add(nodeDescriptor);
    }

    public boolean isUpdated(NodeDescriptor descriptor) {
        return this.myUpdatedDescriptors.contains(descriptor);
    }
}

