/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.lang.Language;
import com.intellij.mock.MockPsiElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockPsiDirectory
extends MockPsiElement
implements PsiDirectory {
    private final PsiPackage myPackage;
    private final Project myProject;

    public MockPsiDirectory(PsiPackage aPackage, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/mock/MockPsiDirectory", "<init>"));
        }
        super(parentDisposable);
        this.myPackage = aPackage;
        this.myProject = null;
    }

    public MockPsiDirectory(Project project, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/mock/MockPsiDirectory", "<init>"));
        }
        super(parentDisposable);
        this.myProject = project;
        this.myPackage = null;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject != null ? this.myProject : super.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockPsiDirectory", "getProject"));
        }
        return project;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = Language.ANY;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockPsiDirectory", "getLanguage"));
        }
        return language;
    }

    @Override
    public void checkCreateFile(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/mock/MockPsiDirectory", "checkCreateFile"));
        }
        throw new IncorrectOperationException("Method checkCreateFile is not yet implemented in " + this.getClass().getName());
    }

    @Override
    public void checkCreateSubdirectory(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/mock/MockPsiDirectory", "checkCreateSubdirectory"));
        }
        throw new IncorrectOperationException("Method checkCreateSubdirectory is not yet implemented in " + this.getClass().getName());
    }

    @Override
    public PsiDirectory getParent() {
        return this.getParentDirectory();
    }

    @Override
    @NotNull
    public PsiFile createFile(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/mock/MockPsiDirectory", "createFile"));
        }
        throw new IncorrectOperationException("Method createFile is not yet implemented in " + this.getClass().getName());
    }

    @Override
    @NotNull
    public PsiFile copyFileFrom(@NotNull String newName, @NotNull PsiFile originalFile) throws IncorrectOperationException {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/mock/MockPsiDirectory", "copyFileFrom"));
        }
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "com/intellij/mock/MockPsiDirectory", "copyFileFrom"));
        }
        throw new IncorrectOperationException("Method copyFileFrom is not yet implemented in " + this.getClass().getName());
    }

    @Override
    @NotNull
    public PsiDirectory createSubdirectory(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/mock/MockPsiDirectory", "createSubdirectory"));
        }
        throw new IncorrectOperationException("Method createSubdirectory is not yet implemented in " + this.getClass().getName());
    }

    @Override
    @Nullable
    public PsiFile findFile(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/mock/MockPsiDirectory", "findFile"));
        }
        throw new UnsupportedOperationException("Method findFile is not yet implemented in " + this.getClass().getName());
    }

    @Override
    @Nullable
    public PsiDirectory findSubdirectory(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/mock/MockPsiDirectory", "findSubdirectory"));
        }
        throw new UnsupportedOperationException("Method findSubdirectory is not yet implemented in " + this.getClass().getName());
    }

    @Override
    @NotNull
    public PsiFile[] getFiles() {
        throw new UnsupportedOperationException("Method getFiles is not yet implemented in " + this.getClass().getName());
    }

    @Override
    @NotNull
    public String getName() {
        throw new UnsupportedOperationException("Method getName is not yet implemented in " + this.getClass().getName());
    }

    @Override
    @Nullable
    public PsiDirectory getParentDirectory() {
        PsiPackage psiPackage = this.myPackage.getParentPackage();
        return psiPackage == null ? null : new MockPsiDirectory(psiPackage, (Disposable)this.getProject());
    }

    @Override
    @NotNull
    public PsiDirectory[] getSubdirectories() {
        throw new UnsupportedOperationException("Method getSubdirectories is not yet implemented in " + this.getClass().getName());
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        LightVirtualFile lightVirtualFile = new LightVirtualFile();
        if (lightVirtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockPsiDirectory", "getVirtualFile"));
        }
        return lightVirtualFile;
    }

    @Override
    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
        throw new UnsupportedOperationException("Method processChildren is not yet implemented in " + this.getClass().getName());
    }

    @Override
    @NotNull
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/mock/MockPsiDirectory", "setName"));
        }
        throw new IncorrectOperationException("Method setName is not yet implemented in " + this.getClass().getName());
    }

    @Override
    public void checkSetName(String name) throws IncorrectOperationException {
        throw new IncorrectOperationException("Method checkSetName is not yet implemented in " + this.getClass().getName());
    }

    @Override
    @Nullable
    public ItemPresentation getPresentation() {
        throw new UnsupportedOperationException("Method getPresentation is not yet implemented in " + this.getClass().getName());
    }
}

