/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Locale;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ApplicationNamesInfo {
    private static final String COMPONENT_NAME = "ApplicationInfo";
    private static final String ELEMENT_NAMES = "names";
    private static final String ATTRIBUTE_PRODUCT = "product";
    private static final String ATTRIBUTE_FULL_NAME = "fullname";
    private static final String ATTRIBUTE_SCRIPT = "script";
    private String myProductName;
    private String myFullProductName;
    private String myLowercaseProductName;
    private String myScriptName;

    @NotNull
    public static ApplicationNamesInfo getInstance() {
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfoHolder.ourInstance;
        if (applicationNamesInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/ApplicationNamesInfo", "getInstance"));
        }
        return applicationNamesInfo;
    }

    private ApplicationNamesInfo() {
        String resource = "/idea/" + ApplicationNamesInfo.getComponentName() + ".xml";
        try {
            Document doc = JDOMUtil.loadDocument(ApplicationNamesInfo.class, (String)resource);
            this.readInfo(doc.getRootElement());
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load resource: " + resource, e);
        }
    }

    private void readInfo(Element rootElement) {
        Element names = rootElement.getChild(ELEMENT_NAMES);
        this.myProductName = names.getAttributeValue(ATTRIBUTE_PRODUCT);
        this.myFullProductName = names.getAttributeValue(ATTRIBUTE_FULL_NAME);
        this.myLowercaseProductName = StringUtil.capitalize((String)this.myProductName.toLowerCase(Locale.US));
        this.myScriptName = names.getAttributeValue(ATTRIBUTE_SCRIPT);
    }

    public String getProductName() {
        return this.myProductName;
    }

    public String getFullProductName() {
        return this.myFullProductName;
    }

    public String getLowercaseProductName() {
        return this.myLowercaseProductName;
    }

    public String getScriptName() {
        return this.myScriptName;
    }

    public static String getComponentName() {
        String prefix = System.getProperty("idea.platform.prefix");
        return prefix != null ? prefix + COMPONENT_NAME : COMPONENT_NAME;
    }

    private static class ApplicationNamesInfoHolder {
        private static final ApplicationNamesInfo ourInstance = new ApplicationNamesInfo();

        private ApplicationNamesInfoHolder() {
        }
    }
}

