/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterPriority;
import org.jetbrains.annotations.NotNull;

public class CommittedChangesFilterKey
implements Comparable<CommittedChangesFilterKey> {
    private final CommittedChangesFilterPriority myPriority;
    @NotNull
    private final String myId;

    public CommittedChangesFilterKey(@NotNull String id, CommittedChangesFilterPriority priority) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/vcs/changes/committed/CommittedChangesFilterKey", "<init>"));
        }
        this.myId = id;
        this.myPriority = priority;
    }

    @Override
    public int compareTo(CommittedChangesFilterKey o) {
        int comp = this.myPriority.getPriority() - o.myPriority.getPriority();
        return comp < 0 ? -1 : (comp == 0 ? 0 : 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommittedChangesFilterKey key = (CommittedChangesFilterKey)o;
        if (this.myPriority.getPriority() != key.myPriority.getPriority()) {
            return false;
        }
        return this.myId.equals(key.myId);
    }

    public int hashCode() {
        int result = this.myPriority.getPriority();
        result = 31 * result + this.myId.hashCode();
        return result;
    }
}

