/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import org.jetbrains.annotations.NotNull;

public class QuerySearchRequest {
    public final Query<PsiReference> query;
    public final SearchRequestCollector collector;
    public final Processor<PsiReference> processor;

    public QuerySearchRequest(@NotNull Query<PsiReference> query, final @NotNull SearchRequestCollector collector, boolean inReadAction, final @NotNull PairProcessor<PsiReference, SearchRequestCollector> processor) {
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/psi/search/QuerySearchRequest", "<init>"));
        }
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "com/intellij/psi/search/QuerySearchRequest", "<init>"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/search/QuerySearchRequest", "<init>"));
        }
        this.query = query;
        this.collector = collector;
        this.processor = inReadAction ? new ReadActionProcessor<PsiReference>(){

            @Override
            public boolean processInReadAction(PsiReference psiReference) {
                return processor.process((Object)psiReference, (Object)collector);
            }
        } : new Processor<PsiReference>(){

            public boolean process(PsiReference psiReference) {
                return processor.process((Object)psiReference, (Object)collector);
            }
        };
    }

    public void runQuery() {
        this.query.forEach(this.processor);
    }

    public String toString() {
        return this.query + " -> " + this.collector;
    }
}

