/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TextFieldWithHistory;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;

public class TextFieldWithStoredHistory
extends TextFieldWithHistory {
    private final String myPropertyName;

    public TextFieldWithStoredHistory(@NonNls String propertyName, boolean cropList) {
        this(propertyName);
    }

    public TextFieldWithStoredHistory(@NonNls String propertyName) {
        this.myPropertyName = propertyName;
        this.reset();
    }

    @Override
    public void addCurrentTextToHistory() {
        super.addCurrentTextToHistory();
        PropertiesComponent.getInstance().setValue(this.myPropertyName, StringUtil.join(this.getHistory(), (String)"\n"));
    }

    public void reset() {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        String history = propertiesComponent.getValue(this.myPropertyName);
        if (history != null) {
            String[] items = history.split("\n");
            ArrayList<String> result = new ArrayList<String>();
            for (String item : items) {
                if (item == null || item.length() <= 0) continue;
                result.add(item);
            }
            this.setHistory(result);
            this.setSelectedItem("");
        }
    }
}

