/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.usages.UsageViewPresentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindUsagesProcessPresentation {
    @NonNls
    public static final String NAME_WITH_MNEMONIC_KEY = "NameWithMnemonic";
    private final UsageViewPresentation myUsageViewPresentation;
    private List<Action> myNotFoundActions;
    private boolean myShowPanelIfOnlyOneUsage;
    private boolean myShowNotFoundMessage;
    private Factory<ProgressIndicator> myProgressIndicatorFactory;
    private Collection<VirtualFile> myLargeFiles;
    private boolean myShowFindOptionsPrompt;
    private Runnable mySearchWithProjectFiles;
    private boolean myCanceled;

    public FindUsagesProcessPresentation(@NotNull UsageViewPresentation presentation) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/usages/FindUsagesProcessPresentation", "<init>"));
        }
        this.myShowFindOptionsPrompt = true;
        this.myUsageViewPresentation = presentation;
    }

    public void addNotFoundAction(@NotNull Action action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/usages/FindUsagesProcessPresentation", "addNotFoundAction"));
        }
        if (this.myNotFoundActions == null) {
            this.myNotFoundActions = new ArrayList<Action>();
        }
        this.myNotFoundActions.add(action);
    }

    @NotNull
    public List<Action> getNotFoundActions() {
        List<Object> list = this.myNotFoundActions == null ? Collections.emptyList() : this.myNotFoundActions;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/FindUsagesProcessPresentation", "getNotFoundActions"));
        }
        return list;
    }

    public boolean isShowNotFoundMessage() {
        return this.myShowNotFoundMessage;
    }

    public void setShowNotFoundMessage(boolean showNotFoundMessage) {
        this.myShowNotFoundMessage = showNotFoundMessage;
    }

    public boolean isShowPanelIfOnlyOneUsage() {
        return this.myShowPanelIfOnlyOneUsage;
    }

    public void setShowPanelIfOnlyOneUsage(boolean showPanelIfOnlyOneUsage) {
        this.myShowPanelIfOnlyOneUsage = showPanelIfOnlyOneUsage;
    }

    public Factory<ProgressIndicator> getProgressIndicatorFactory() {
        return this.myProgressIndicatorFactory;
    }

    public void setProgressIndicatorFactory(@NotNull Factory<ProgressIndicator> progressIndicatorFactory) {
        if (progressIndicatorFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicatorFactory", "com/intellij/usages/FindUsagesProcessPresentation", "setProgressIndicatorFactory"));
        }
        this.myProgressIndicatorFactory = progressIndicatorFactory;
    }

    @Nullable
    public Runnable searchIncludingProjectFileUsages() {
        return this.mySearchWithProjectFiles;
    }

    public void projectFileUsagesFound(@NotNull Runnable searchWithProjectFiles) {
        if (searchWithProjectFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchWithProjectFiles", "com/intellij/usages/FindUsagesProcessPresentation", "projectFileUsagesFound"));
        }
        this.mySearchWithProjectFiles = searchWithProjectFiles;
    }

    public void setLargeFilesWereNotScanned(@NotNull Collection<VirtualFile> largeFiles) {
        if (largeFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "largeFiles", "com/intellij/usages/FindUsagesProcessPresentation", "setLargeFilesWereNotScanned"));
        }
        this.myLargeFiles = largeFiles;
    }

    @NotNull
    public Collection<VirtualFile> getLargeFiles() {
        Collection<Object> collection = this.myLargeFiles == null ? Collections.emptyList() : this.myLargeFiles;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/FindUsagesProcessPresentation", "getLargeFiles"));
        }
        return collection;
    }

    public boolean isShowFindOptionsPrompt() {
        return this.myShowFindOptionsPrompt;
    }

    @NotNull
    public UsageViewPresentation getUsageViewPresentation() {
        UsageViewPresentation usageViewPresentation = this.myUsageViewPresentation;
        if (usageViewPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/FindUsagesProcessPresentation", "getUsageViewPresentation"));
        }
        return usageViewPresentation;
    }

    public void setShowFindOptionsPrompt(boolean showFindOptionsPrompt) {
        this.myShowFindOptionsPrompt = showFindOptionsPrompt;
    }

    public void setCanceled(boolean canceled) {
        this.myCanceled = canceled;
    }

    public boolean isCanceled() {
        return this.myCanceled;
    }
}

