/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java;

import com.intellij.openapi.util.Comparing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.ex.JpsElementBase;

public class JavaSourceRootProperties
extends JpsElementBase<JavaSourceRootProperties>
implements JpsSimpleElement<JavaSourceRootProperties> {
    private String myPackagePrefix;
    private boolean myForGeneratedSources;

    public JavaSourceRootProperties() {
        this.myPackagePrefix = "";
    }

    public JavaSourceRootProperties(@NotNull String packagePrefix) {
        if (packagePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagePrefix", "org/jetbrains/jps/model/java/JavaSourceRootProperties", "<init>"));
        }
        this.myPackagePrefix = "";
        this.myPackagePrefix = packagePrefix;
    }

    public JavaSourceRootProperties(@NotNull String packagePrefix, boolean forGeneratedSources) {
        if (packagePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagePrefix", "org/jetbrains/jps/model/java/JavaSourceRootProperties", "<init>"));
        }
        this.myPackagePrefix = "";
        this.myPackagePrefix = packagePrefix;
        this.myForGeneratedSources = forGeneratedSources;
    }

    @NotNull
    public String getPackagePrefix() {
        String string = this.myPackagePrefix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/JavaSourceRootProperties", "getPackagePrefix"));
        }
        return string;
    }

    @Override
    @NotNull
    public JavaSourceRootProperties createCopy() {
        JavaSourceRootProperties javaSourceRootProperties = new JavaSourceRootProperties(this.myPackagePrefix, this.myForGeneratedSources);
        if (javaSourceRootProperties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/JavaSourceRootProperties", "createCopy"));
        }
        return javaSourceRootProperties;
    }

    public boolean isForGeneratedSources() {
        return this.myForGeneratedSources;
    }

    public void setPackagePrefix(@NotNull String packagePrefix) {
        if (packagePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagePrefix", "org/jetbrains/jps/model/java/JavaSourceRootProperties", "setPackagePrefix"));
        }
        if (!Comparing.equal((String)this.myPackagePrefix, (String)packagePrefix)) {
            this.myPackagePrefix = packagePrefix;
            this.fireElementChanged();
        }
    }

    public void setForGeneratedSources(boolean forGeneratedSources) {
        if (this.myForGeneratedSources != forGeneratedSources) {
            this.myForGeneratedSources = forGeneratedSources;
            this.fireElementChanged();
        }
    }

    @Override
    public void applyChanges(@NotNull JavaSourceRootProperties modified) {
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "org/jetbrains/jps/model/java/JavaSourceRootProperties", "applyChanges"));
        }
        this.setPackagePrefix(modified.myPackagePrefix);
        this.setForGeneratedSources(modified.myForGeneratedSources);
    }

    @Override
    public void setData(@NotNull JavaSourceRootProperties data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/jps/model/java/JavaSourceRootProperties", "setData"));
        }
        this.applyChanges(data);
    }

    @Override
    @NotNull
    public JavaSourceRootProperties getData() {
        JavaSourceRootProperties javaSourceRootProperties = this;
        if (javaSourceRootProperties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/JavaSourceRootProperties", "getData"));
        }
        return javaSourceRootProperties;
    }
}

