/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.internal.Actions;
import org.gradle.internal.BiAction;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.ProjectionBackedModelCreator;
import org.gradle.model.internal.core.UnmanagedModelProjection;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.NestedModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class ModelCreators {
    public static <T> Builder serviceInstance(ModelReference<T> modelReference, T instance) {
        return ModelCreators.bridgedInstance(modelReference, instance).service(true);
    }

    public static <T> Builder bridgedInstance(ModelReference<T> modelReference, T instance) {
        return ModelCreators.unmanagedInstance(modelReference, Factories.constant(instance), (Action<? super MutableModelNode>)Actions.doNothing());
    }

    public static <T> Builder unmanagedInstance(ModelReference<T> modelReference, Factory<? extends T> factory) {
        return ModelCreators.unmanagedInstance(modelReference, factory, (Action<? super MutableModelNode>)Actions.doNothing());
    }

    public static <T> Builder unmanagedInstance(ModelReference<T> modelReference, final Factory<? extends T> factory, final Action<? super MutableModelNode> initializer) {
        return ModelCreators.unmanagedInstanceOf(modelReference, new Transformer<T, MutableModelNode>(){

            public T transform(MutableModelNode modelNode) {
                Object t = factory.create();
                initializer.execute((Object)modelNode);
                return t;
            }
        });
    }

    public static <T> Builder unmanagedInstanceOf(final ModelReference<T> modelReference, final Transformer<? extends T, ? super MutableModelNode> factory) {
        return ModelCreators.of(modelReference.getPath(), (Action<? super MutableModelNode>)new Action<MutableModelNode>(){

            public void execute(MutableModelNode modelNode) {
                Object t = factory.transform((Object)modelNode);
                modelNode.setPrivateData(modelReference.getType(), t);
            }
        }).withProjection(UnmanagedModelProjection.of(modelReference.getType()));
    }

    public static Builder of(ModelPath path) {
        return new Builder(path);
    }

    public static Builder of(ModelPath path, NodeInitializer initializer) {
        return new Builder(path, initializer);
    }

    public static Builder of(ModelPath path, ModelReference<?> input, BiAction<? super MutableModelNode, ? super List<ModelView<?>>> initializer) {
        return ModelCreators.of(path, Collections.singletonList(input), initializer);
    }

    public static Builder of(ModelPath path, List<? extends ModelReference<?>> inputs, BiAction<? super MutableModelNode, ? super List<ModelView<?>>> initializer) {
        return new Builder(path).action(ModelActionRole.Create, inputs, initializer);
    }

    public static Builder of(ModelPath path, Action<? super MutableModelNode> initializer) {
        return new Builder(path).action(ModelActionRole.Create, initializer);
    }

    public static <T> Builder of(final ModelReference<T> modelReference, final Factory<? extends T> factory) {
        return ModelCreators.of(modelReference.getPath(), (Action<? super MutableModelNode>)new Action<MutableModelNode>(){

            public void execute(MutableModelNode modelNode) {
                Object value = factory.create();
                modelNode.setPrivateData(modelReference.getType(), value);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NotThreadSafe
    public static class Builder {
        private final ModelPath path;
        private final List<ModelProjection> projections = new ArrayList<ModelProjection>();
        private final ListMultimap<ModelActionRole, ModelAction> actions = ArrayListMultimap.create();
        private final NodeInitializer nodeInitializer;
        private boolean service;
        private boolean ephemeral;
        private boolean hidden;
        private ModelRuleDescriptor modelRuleDescriptor;

        private Builder(ModelPath path) {
            this(path, (NodeInitializer)null);
        }

        private Builder(ModelPath path, NodeInitializer nodeInitializer) {
            this.path = path;
            this.nodeInitializer = nodeInitializer;
        }

        public Builder descriptor(String descriptor) {
            this.modelRuleDescriptor = new SimpleModelRuleDescriptor(descriptor);
            return this;
        }

        public Builder descriptor(ModelRuleDescriptor descriptor) {
            this.modelRuleDescriptor = descriptor;
            return this;
        }

        public Builder descriptor(ModelRuleDescriptor parent, ModelRuleDescriptor child) {
            this.modelRuleDescriptor = new NestedModelRuleDescriptor(parent, child);
            return this;
        }

        public Builder descriptor(ModelRuleDescriptor parent, String child) {
            this.modelRuleDescriptor = new NestedModelRuleDescriptor(parent, new SimpleModelRuleDescriptor(child));
            return this;
        }

        public Builder action(ModelActionRole role, ModelAction action) {
            this.actions.put((Object)role, (Object)action);
            return this;
        }

        public Builder action(ModelActionRole role, final Action<? super MutableModelNode> initializer) {
            this.action(role, new BuilderModelAction(){

                @Override
                public void execute(MutableModelNode modelNode, List<ModelView<?>> inputs) {
                    initializer.execute((Object)modelNode);
                }

                @Override
                public List<? extends ModelReference<?>> getInputs() {
                    return Collections.emptyList();
                }
            });
            return this;
        }

        public Builder action(ModelActionRole role, ModelReference<?> input, BiAction<? super MutableModelNode, ? super List<ModelView<?>>> initializer) {
            this.action(role, Collections.singletonList(input), initializer);
            return this;
        }

        public Builder action(ModelActionRole role, final List<? extends ModelReference<?>> inputs, final BiAction<? super MutableModelNode, ? super List<ModelView<?>>> initializer) {
            this.action(role, new BuilderModelAction(){

                @Override
                public void execute(MutableModelNode modelNode, List<ModelView<?>> inputs2) {
                    initializer.execute((Object)modelNode, inputs2);
                }

                @Override
                public List<? extends ModelReference<?>> getInputs() {
                    return inputs;
                }
            });
            return this;
        }

        public Builder withProjection(ModelProjection projection) {
            this.projections.add(projection);
            return this;
        }

        public Builder hidden(boolean flag) {
            this.hidden = flag;
            return this;
        }

        public Builder ephemeral(boolean flag) {
            this.ephemeral = flag;
            return this;
        }

        public Builder service(boolean flag) {
            this.service = flag;
            return this;
        }

        public ModelCreator build() {
            if (this.nodeInitializer != null) {
                this.action(ModelActionRole.Create, new BuilderModelAction(){

                    @Override
                    public void execute(MutableModelNode modelNode, List<ModelView<?>> inputs) {
                        Builder.this.nodeInitializer.execute(modelNode, inputs);
                    }

                    @Override
                    public List<? extends ModelReference<?>> getInputs() {
                        return Builder.this.nodeInitializer.getInputs();
                    }
                });
                this.projections.addAll(this.nodeInitializer.getProjections());
                ModelAction projector = this.nodeInitializer.getProjector(this.path, this.modelRuleDescriptor);
                if (projector != null) {
                    this.action(ModelActionRole.DefineProjections, projector);
                }
            }
            return new ProjectionBackedModelCreator(this.path, this.modelRuleDescriptor, this.service, this.ephemeral, this.hidden || this.service, (Iterable<? extends ModelProjection>)this.projections, (Multimap<ModelActionRole, ? extends ModelAction>)this.actions);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private abstract class BuilderModelAction
        implements ModelAction {
            private BuilderModelAction() {
            }

            @Override
            public ModelReference<?> getSubject() {
                return ModelReference.of(Builder.this.path);
            }

            @Override
            public ModelRuleDescriptor getDescriptor() {
                return Builder.this.modelRuleDescriptor;
            }
        }
    }
}

