/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import java.util.Collection;
import org.gradle.api.Named;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelCreators;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.NodeInitializerContext;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.core.UnmanagedModelProjection;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.ReadonlyImmutableManagedPropertyException;
import org.gradle.model.internal.inspect.UnmanagedPropertyMissingSetterException;
import org.gradle.model.internal.manage.instance.ManagedProxyFactory;
import org.gradle.model.internal.manage.projection.ManagedModelProjection;
import org.gradle.model.internal.manage.schema.ManagedImplModelSchema;
import org.gradle.model.internal.manage.schema.ModelCollectionSchema;
import org.gradle.model.internal.manage.schema.ModelManagedImplStructSchema;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.ModelValueSchema;
import org.gradle.model.internal.manage.schema.ScalarCollectionSchema;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractManagedModelInitializer<T>
implements NodeInitializer {
    protected final ModelManagedImplStructSchema<T> schema;
    protected final ModelSchemaStore schemaStore;
    protected final ManagedProxyFactory proxyFactory;

    public AbstractManagedModelInitializer(ModelManagedImplStructSchema<T> schema, ModelSchemaStore schemaStore, ManagedProxyFactory proxyFactory) {
        this.schema = schema;
        this.schemaStore = schemaStore;
        this.proxyFactory = proxyFactory;
    }

    protected void addPropertyLinks(MutableModelNode modelNode, NodeInitializerRegistry nodeInitializerRegistry, Collection<ModelProperty<?>> properties) {
        ModelProperty<?> nameProperty;
        for (ModelProperty<?> property : properties) {
            this.addPropertyLink(modelNode, property, nodeInitializerRegistry);
        }
        if (this.isANamedType() && (nameProperty = this.schema.getProperty("name")) != null && nameProperty.getStateManagementType().equals((Object)ModelProperty.StateManagementType.MANAGED) && properties.contains(nameProperty)) {
            MutableModelNode nameLink = modelNode.getLink("name");
            if (nameLink == null) {
                throw new IllegalStateException("expected name node for " + modelNode.getPath());
            }
            nameLink.setPrivateData(ModelType.of(String.class), modelNode.getPath().getName());
        }
    }

    private <P> void addPropertyLink(MutableModelNode modelNode, ModelProperty<P> property, NodeInitializerRegistry nodeInitializerRegistry) {
        if (!property.getStateManagementType().equals((Object)ModelProperty.StateManagementType.MANAGED)) {
            return;
        }
        ModelType<P> propertyType = property.getType();
        ModelSchema<P> propertySchema = this.schemaStore.getSchema(propertyType);
        this.validateProperty(propertySchema, property, nodeInitializerRegistry);
        ModelRuleDescriptor descriptor = modelNode.getDescriptor();
        ModelPath childPath = modelNode.getPath().child(property.getName());
        if (propertySchema instanceof ManagedImplModelSchema) {
            if (!property.isWritable()) {
                ModelCreator creator = ModelCreators.of(childPath, nodeInitializerRegistry.getNodeInitializer(NodeInitializerContext.forProperty(propertySchema.getType(), property, this.schema.getType()))).descriptor(descriptor).build();
                modelNode.addLink(creator);
            } else if (propertySchema instanceof ScalarCollectionSchema) {
                ModelCreator creator = ModelCreators.of(childPath, nodeInitializerRegistry.getNodeInitializer(NodeInitializerContext.forProperty(propertySchema.getType(), property, this.schema.getType()))).descriptor(descriptor).build();
                modelNode.addLink(creator);
            } else {
                ModelManagedImplStructSchema structSchema = (ModelManagedImplStructSchema)propertySchema;
                ManagedModelProjection projection = new ManagedModelProjection(structSchema, null, this.schemaStore, this.proxyFactory);
                ModelCreator creator = ModelCreators.of(childPath).withProjection(projection).descriptor(descriptor).build();
                modelNode.addReference(creator);
            }
        } else {
            UnmanagedModelProjection<P> projection = new UnmanagedModelProjection<P>(propertyType, true, true);
            ModelCreators.Builder creatorBuilder = this.shouldHaveANodeInitializer(property, propertySchema) ? ModelCreators.of(childPath, nodeInitializerRegistry.getNodeInitializer(NodeInitializerContext.forProperty(propertyType, property, this.schema.getType()))) : ModelCreators.of(childPath);
            creatorBuilder.withProjection(projection).descriptor(descriptor);
            modelNode.addLink(creatorBuilder.build());
        }
    }

    private <P> void validateProperty(ModelSchema<P> propertySchema, ModelProperty<P> property, NodeInitializerRegistry nodeInitializerRegistry) {
        if (propertySchema instanceof ManagedImplModelSchema) {
            if (!property.isWritable()) {
                if (propertySchema instanceof ModelCollectionSchema && !(propertySchema instanceof ScalarCollectionSchema)) {
                    ModelCollectionSchema propertyCollectionsSchema = (ModelCollectionSchema)propertySchema;
                    ModelType elementType = propertyCollectionsSchema.getElementType();
                    nodeInitializerRegistry.ensureHasInitializer(NodeInitializerContext.forProperty(elementType, property, this.schema.getType()));
                }
                if (property.isDeclaredAsHavingUnmanagedType()) {
                    throw new UnmanagedPropertyMissingSetterException(property);
                }
            }
        } else if (!(this.shouldHaveANodeInitializer(property, propertySchema) || property.isWritable() || this.isNamePropertyOfANamedType(property))) {
            throw new ReadonlyImmutableManagedPropertyException(this.schema.getType(), property.getName(), property.getType());
        }
    }

    private <P> boolean isNamePropertyOfANamedType(ModelProperty<P> property) {
        return this.isANamedType() && "name".equals(property.getName());
    }

    public boolean isANamedType() {
        return Named.class.isAssignableFrom(this.schema.getType().getRawClass());
    }

    private <P> boolean shouldHaveANodeInitializer(ModelProperty<P> property, ModelSchema<P> propertySchema) {
        return !this.isAModelValueSchema(propertySchema) && !property.isDeclaredAsHavingUnmanagedType();
    }

    private <P> boolean isAModelValueSchema(ModelSchema<P> propertySchema) {
        return propertySchema instanceof ModelValueSchema;
    }
}

