/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import java.util.Collection;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.registry.BindingPredicate;
import org.gradle.model.internal.registry.ModelBinding;
import org.gradle.model.internal.registry.ModelNodeInternal;
import org.gradle.model.internal.registry.RuleBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ModelActionBinder
extends RuleBinder {
    private final ModelBinding subjectBinding;
    private final ModelAction action;

    public ModelActionBinder(BindingPredicate subjectReference, List<BindingPredicate> inputs, ModelAction action, Collection<RuleBinder> binders) {
        super(subjectReference, inputs, action.getDescriptor(), binders);
        this.subjectBinding = this.binding(subjectReference, true, new Action<ModelBinding>(){

            public void execute(ModelBinding modelBinding) {
                ModelNodeInternal node = modelBinding.getNode();
                BindingPredicate predicate = modelBinding.getPredicate();
                if (predicate.getState() != null && node.isAtLeast(predicate.getState())) {
                    throw new IllegalStateException(String.format("Cannot add rule %s for model element '%s' at state %s as this element is already at state %s.", new Object[]{modelBinding.referrer, node.getPath(), predicate.getState().previous(), node.getState()}));
                }
                ModelActionBinder.this.maybeFire();
            }
        });
        this.action = action;
    }

    public ModelAction getAction() {
        return this.action;
    }

    @Override
    public ModelBinding getSubjectBinding() {
        return this.subjectBinding;
    }

    @Override
    public boolean isBound() {
        return this.subjectBinding != null && this.subjectBinding.isBound() && super.isBound();
    }

    public String toString() {
        return String.format("%s[%s - %s]", this.getClass().getSimpleName(), this.subjectBinding, this.action.getDescriptor());
    }
}

