/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.gradle.api.Action;
import org.gradle.api.Nullable;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.registry.BindingPredicate;
import org.gradle.model.internal.registry.ModelBinding;
import org.gradle.model.internal.registry.ModelNodeInternal;
import org.gradle.model.internal.registry.OneOfTypeBinderCreationListener;
import org.gradle.model.internal.registry.PathBinderCreationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
abstract class RuleBinder {
    private final ModelRuleDescriptor descriptor;
    private final BindingPredicate subjectReference;
    private final List<BindingPredicate> inputReferences;
    private final Collection<RuleBinder> binders;
    private int inputsBound;
    private List<ModelBinding> inputBindings;
    private Action<ModelBinding> inputBindAction;

    public RuleBinder(BindingPredicate subjectReference, List<BindingPredicate> inputReferences, ModelRuleDescriptor descriptor, Collection<RuleBinder> binders) {
        this.subjectReference = subjectReference;
        this.inputReferences = inputReferences;
        this.descriptor = descriptor;
        this.binders = binders;
        this.inputBindAction = new Action<ModelBinding>(){

            public void execute(ModelBinding modelBinding) {
                ModelNodeInternal node = modelBinding.getNode();
                BindingPredicate reference = modelBinding.getPredicate();
                if (reference.getState() != null && node.getState().compareTo(reference.getState()) > 0) {
                    throw new IllegalStateException(String.format("Cannot add rule %s with input model element '%s' at state %s as this element is already at state %s.", new Object[]{modelBinding.referrer, node.getPath(), reference.getState(), node.getState()}));
                }
                ++RuleBinder.this.inputsBound;
                RuleBinder.this.maybeFire();
            }
        };
        this.inputBindings = this.inputBindings(inputReferences);
        if (!this.isBound()) {
            binders.add(this);
        }
    }

    private List<ModelBinding> inputBindings(List<BindingPredicate> inputReferences) {
        if (inputReferences.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ModelBinding> bindings = new ArrayList<ModelBinding>(inputReferences.size());
        for (BindingPredicate inputReference : inputReferences) {
            bindings.add(this.binding(inputReference, false, this.inputBindAction));
        }
        return bindings;
    }

    protected ModelBinding binding(BindingPredicate reference, boolean writable, Action<ModelBinding> bindAction) {
        if (reference.getPath() != null) {
            return new PathBinderCreationListener(this.descriptor, reference, writable, bindAction);
        }
        return new OneOfTypeBinderCreationListener(this.descriptor, reference, writable, bindAction);
    }

    public BindingPredicate getSubjectReference() {
        return this.subjectReference;
    }

    @Nullable
    public ModelBinding getSubjectBinding() {
        return null;
    }

    public List<ModelBinding> getInputBindings() {
        return this.inputBindings;
    }

    public ModelRuleDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected void maybeFire() {
        if (this.isBound()) {
            this.binders.remove(this);
        }
    }

    public boolean isBound() {
        return this.inputsBound == this.inputReferences.size();
    }
}

