/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.type;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessControlException;
import java.util.Arrays;
import org.gradle.model.internal.type.ModelType;
import org.gradle.model.internal.type.TypeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TypeVariableTypeWrapper<D extends GenericDeclaration>
implements TypeWrapper {
    private static final Class<?>[] TYPE_VARIABLE_INTERFACE = new Class[]{TypeVariable.class};
    private final String name;
    private final TypeWrapper[] bounds;
    private final int hashCode;

    public TypeVariableTypeWrapper(String name, TypeWrapper[] bounds, int hashCode) {
        this.name = name;
        this.bounds = bounds;
        this.hashCode = hashCode;
    }

    @Override
    public Type unwrap() {
        return (Type)Proxy.newProxyInstance(this.getClass().getClassLoader(), TYPE_VARIABLE_INTERFACE, (InvocationHandler)new TypeVariableInvocationHandler(this));
    }

    @Override
    public void collectClasses(ImmutableList.Builder<Class<?>> builder) {
        for (TypeWrapper bound : this.bounds) {
            bound.collectClasses(builder);
        }
    }

    @Override
    public String getRepresentation(boolean full) {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public Type[] getBounds() {
        return ModelType.unwrap(this.bounds);
    }

    public boolean equals(Object o) {
        if (!(o instanceof TypeVariable)) {
            return false;
        }
        TypeVariable var2 = (TypeVariable)o;
        return Objects.equal((Object)this.getName(), (Object)var2.getName()) && Arrays.equals(this.getBounds(), var2.getBounds());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return false;
    }

    public Annotation[] getDeclaredAnnotations() {
        return new Annotation[0];
    }

    public Annotation[] getAnnotations() {
        return new Annotation[0];
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return null;
    }

    public D getGenericDeclaration() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TypeVariableInvocationHandler
    implements InvocationHandler {
        private static final ImmutableMap<String, Method> TYPE_VARIABLE_METHODS;
        private final TypeVariableTypeWrapper<?> wrapper;

        TypeVariableInvocationHandler(TypeVariableTypeWrapper<?> wrapper) {
            this.wrapper = wrapper;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            Method typeVariableMethod = (Method)TYPE_VARIABLE_METHODS.get((Object)methodName);
            if (typeVariableMethod == null) {
                throw new UnsupportedOperationException(methodName);
            }
            try {
                return typeVariableMethod.invoke(this.wrapper, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        static {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Method method : TypeVariableTypeWrapper.class.getMethods()) {
                if (!method.getDeclaringClass().equals(TypeVariableTypeWrapper.class)) continue;
                try {
                    method.setAccessible(true);
                }
                catch (AccessControlException e) {
                    // empty catch block
                }
                builder.put((Object)method.getName(), (Object)method);
            }
            TYPE_VARIABLE_METHODS = builder.build();
        }
    }
}

