/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.type;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import org.gradle.model.internal.type.ModelType;
import org.gradle.model.internal.type.TypeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WildcardTypeWrapper
implements WildcardType,
TypeWrapper {
    private final TypeWrapper[] upperBounds;
    private final TypeWrapper[] lowerBounds;
    private final int hashCode;

    public WildcardTypeWrapper(TypeWrapper[] upperBounds, TypeWrapper[] lowerBounds, int hashCode) {
        this.upperBounds = upperBounds;
        this.lowerBounds = lowerBounds;
        this.hashCode = hashCode;
    }

    @Override
    public Type[] getUpperBounds() {
        return ModelType.unwrap(this.upperBounds);
    }

    @Override
    public Type[] getLowerBounds() {
        return ModelType.unwrap(this.lowerBounds);
    }

    @Override
    public Type unwrap() {
        return this;
    }

    @Override
    public void collectClasses(ImmutableList.Builder<Class<?>> builder) {
        for (TypeWrapper upperBound : this.upperBounds) {
            upperBound.collectClasses(builder);
        }
        for (TypeWrapper lowerBound : this.lowerBounds) {
            lowerBound.collectClasses(builder);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof WildcardType)) {
            return false;
        }
        WildcardType var2 = (WildcardType)o;
        return Arrays.equals(this.getLowerBounds(), var2.getLowerBounds()) && Arrays.equals(this.getUpperBounds(), var2.getUpperBounds());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.getRepresentation(true);
    }

    @Override
    public String getRepresentation(boolean full) {
        TypeWrapper[] bounds = this.lowerBounds;
        StringBuilder sb = new StringBuilder();
        if (this.lowerBounds.length > 0) {
            sb.append("? super ");
        } else {
            Type[] upperBounds = this.getUpperBounds();
            if (upperBounds.length > 0 && !upperBounds[0].equals(Object.class)) {
                bounds = this.upperBounds;
                sb.append("? extends ");
            } else {
                return "?";
            }
        }
        assert (bounds.length > 0);
        boolean first = true;
        for (TypeWrapper bound : bounds) {
            if (!first) {
                sb.append(" & ");
            }
            first = false;
            sb.append(bound.getRepresentation(full));
        }
        return sb.toString();
    }
}

