/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.incremental.BuilderRegistry;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;

public class JavaSourceRootDescriptor
extends BuildRootDescriptor {
    @NotNull
    public final File root;
    @NotNull
    public final ModuleBuildTarget target;
    public final boolean isGeneratedSources;
    public final boolean isTemp;
    private final String myPackagePrefix;
    private final Set<File> myExcludes;

    public JavaSourceRootDescriptor(@NotNull File root, @NotNull ModuleBuildTarget target, boolean isGenerated, boolean isTemp, @NotNull String packagePrefix, @NotNull Set<File> excludes) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/jps/builders/java/JavaSourceRootDescriptor", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jps/builders/java/JavaSourceRootDescriptor", "<init>"));
        }
        if (packagePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagePrefix", "org/jetbrains/jps/builders/java/JavaSourceRootDescriptor", "<init>"));
        }
        if (excludes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludes", "org/jetbrains/jps/builders/java/JavaSourceRootDescriptor", "<init>"));
        }
        this.root = root;
        this.target = target;
        this.isGeneratedSources = isGenerated;
        this.isTemp = isTemp;
        this.myPackagePrefix = packagePrefix;
        this.myExcludes = excludes;
    }

    public String toString() {
        return "RootDescriptor{target='" + this.target + '\'' + ", root=" + this.root + ", generated=" + this.isGeneratedSources + '}';
    }

    @Override
    @NotNull
    public Set<File> getExcludedRoots() {
        Set<File> set = this.myExcludes;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/JavaSourceRootDescriptor", "getExcludedRoots"));
        }
        return set;
    }

    @NotNull
    public String getPackagePrefix() {
        String string = this.myPackagePrefix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/JavaSourceRootDescriptor", "getPackagePrefix"));
        }
        return string;
    }

    @Override
    public String getRootId() {
        return FileUtil.toSystemIndependentName((String)this.root.getPath());
    }

    @Override
    public File getRootFile() {
        return this.root;
    }

    public ModuleBuildTarget getTarget() {
        return this.target;
    }

    @Override
    @NotNull
    public FileFilter createFileFilter() {
        final JpsCompilerExcludes excludes = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(this.target.getModule().getProject()).getCompilerExcludes();
        final FileFilter baseFilter = BuilderRegistry.getInstance().getModuleBuilderFileFilter();
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return baseFilter.accept(file) && !excludes.isExcluded(file);
            }
        };
        if (fileFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/JavaSourceRootDescriptor", "createFileFilter"));
        }
        return fileFilter;
    }

    @Override
    public boolean isGenerated() {
        return this.isGeneratedSources;
    }

    @Override
    public boolean canUseFileCache() {
        return true;
    }
}

