/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class JpsArtifactPathUtil {
    public static String trimForwardSlashes(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/jps/incremental/artifacts/impl/JpsArtifactPathUtil", "trimForwardSlashes"));
        }
        while (path.length() != 0 && (path.charAt(0) == '/' || path.charAt(0) == File.separatorChar)) {
            path = path.substring(1);
        }
        return path;
    }

    public static String appendToPath(@NotNull String basePath, @NotNull String relativePath) {
        boolean startsWithSlash;
        if (basePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basePath", "org/jetbrains/jps/incremental/artifacts/impl/JpsArtifactPathUtil", "appendToPath"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "org/jetbrains/jps/incremental/artifacts/impl/JpsArtifactPathUtil", "appendToPath"));
        }
        boolean endsWithSlash = StringUtilRt.endsWithChar((CharSequence)basePath, (char)'/') || StringUtilRt.endsWithChar((CharSequence)basePath, (char)'\\');
        boolean bl = startsWithSlash = StringUtil.startsWithChar((CharSequence)relativePath, (char)'/') || StringUtil.startsWithChar((CharSequence)relativePath, (char)'\\');
        String tail = endsWithSlash && startsWithSlash ? JpsArtifactPathUtil.trimForwardSlashes(relativePath) : (!endsWithSlash && !startsWithSlash && basePath.length() > 0 && relativePath.length() > 0 ? "/" + relativePath : relativePath);
        return basePath + tail;
    }
}

