/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath;

import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.lexer.LookAheadLexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.io.IOException;
import org.intellij.lang.xpath.XPath2TokenTypes;
import org.intellij.lang.xpath.XPathTokenTypes;
import org.intellij.lang.xpath._XPathLexer;

public final class XPathLexer
extends LookAheadLexer {
    private static final TokenSet WS_OR_COMMENT = TokenSet.create((IElementType[])new IElementType[]{XPathTokenTypes.WHITESPACE, XPath2TokenTypes.COMMENT});
    private final boolean myXPath2Syntax;

    private XPathLexer(boolean xpath2Syntax) {
        super((Lexer)new FlexAdapter((FlexLexer)new _XPathLexer(xpath2Syntax){

            @Override
            protected void readComment() throws IOException {
                IElementType type;
                int state = this.yystate();
                int start = this.getTokenStart();
                while ((type = this.advance()) != null && type != XPath2TokenTypes.END_COMMENT) {
                }
                this.setStart(start);
                this.yybegin(state);
            }
        }));
        this.myXPath2Syntax = xpath2Syntax;
    }

    protected void lookAhead(Lexer baseLexer) {
        IElementType type = baseLexer.getTokenType();
        if (type == XPath2TokenTypes.IF) {
            if (this.replaceTokenNotFollowedBy(baseLexer, XPathTokenTypes.NCNAME, XPathTokenTypes.LPAREN)) {
                return;
            }
        } else if (type == XPathTokenTypes.NCNAME) {
            if (this.handleNCName(baseLexer, type)) {
                return;
            }
        } else if (type == XPathTokenTypes.RPAREN) {
            if (this.getState() == 3 && !XPathLexer.lookingAt(baseLexer, XPath2TokenTypes.OCCURRENCE_OPS)) {
                XPathLexer.setState(baseLexer, 0);
            }
        } else if (type == XPathTokenTypes.AXIS_NAME) {
            if (this.replaceTokenNotFollowedBy(baseLexer, XPathTokenTypes.NCNAME, XPathTokenTypes.COLCOL)) {
                XPathLexer.setState(baseLexer, 0);
                return;
            }
        } else if (type == XPathTokenTypes.NODE_TYPE) {
            String text = baseLexer.getTokenText();
            if ("attribute".equals(text) || "element".equals(text) || "schema-element".equals(text) || "schema-attribute".equals(text) || "document-node".equals(text)) {
                if ("attribute".equals(text) && this.replaceTokenFollowedBy(baseLexer, XPathTokenTypes.AXIS_NAME, XPathTokenTypes.COLCOL)) {
                    XPathLexer.setState(baseLexer, 1);
                    return;
                }
                if (this.myXPath2Syntax) {
                    if (!this.replaceTokenNotFollowedBy(baseLexer, XPathTokenTypes.NCNAME, XPathTokenTypes.LPAREN)) {
                        this.advanceAs(baseLexer, type);
                    }
                } else {
                    this.handleNCName(baseLexer, XPathTokenTypes.NCNAME);
                }
                return;
            }
            if (this.replaceTokenNotFollowedBy(baseLexer, XPathTokenTypes.NCNAME, XPathTokenTypes.LPAREN)) {
                XPathLexer.setState(baseLexer, 0);
                return;
            }
        } else if ((XPath2TokenTypes.QUANTIFIERS.contains(type) || type == XPath2TokenTypes.FOR) && this.replaceTokenNotFollowedBy(baseLexer, XPathTokenTypes.NCNAME, XPathTokenTypes.DOLLAR)) {
            return;
        }
        this.advanceAs(baseLexer, type);
    }

    private boolean handleNCName(Lexer baseLexer, IElementType type) {
        if (baseLexer.getState() == 3) {
            if (!XPathLexer.lookingAt(baseLexer, XPathTokenTypes.COL, XPathTokenTypes.NCNAME) && !XPathLexer.lookingAt(baseLexer, XPath2TokenTypes.OCCURRENCE_OPS)) {
                XPathLexer.setState(baseLexer, 1);
            }
        } else {
            if (!this.replaceTokenFollowedBy(baseLexer, XPathTokenTypes.FUNCTION_NAME, XPathTokenTypes.LPAREN)) {
                if (XPathLexer.lookingAt(baseLexer, XPathTokenTypes.COL, XPathTokenTypes.NCNAME, XPathTokenTypes.LPAREN)) {
                    this.advanceAs(baseLexer, XPathTokenTypes.EXT_PREFIX);
                } else if (!this.replaceTokenFollowedBy(baseLexer, XPathTokenTypes.BAD_AXIS_NAME, XPathTokenTypes.COLCOL)) {
                    this.advanceAs(baseLexer, type);
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean lookingAt(Lexer lexer, TokenSet tokenSet) {
        LexerPosition position = lexer.getCurrentPosition();
        try {
            lexer.advance();
            XPathLexer.skipWhitespaceAnComments(lexer);
            boolean bl = tokenSet.contains(lexer.getTokenType());
            return bl;
        }
        finally {
            lexer.restore(position);
        }
    }

    private static void setState(Lexer baseLexer, int state) {
        ((FlexAdapter)baseLexer).getFlex().yybegin(state);
    }

    private boolean replaceTokenNotFollowedBy(Lexer baseLexer, IElementType replacement, IElementType nextToken) {
        if (!XPathLexer.lookingAt(baseLexer, nextToken)) {
            this.treatAs(baseLexer, replacement);
            return true;
        }
        return false;
    }

    private boolean replaceTokenFollowedBy(Lexer baseLexer, IElementType replacement, IElementType nextToken) {
        if (XPathLexer.lookingAt(baseLexer, nextToken)) {
            this.treatAs(baseLexer, replacement);
            return true;
        }
        return false;
    }

    private void treatAs(Lexer lexer, IElementType type) {
        if (type == XPathTokenTypes.NCNAME) {
            if (!this.handleNCName(lexer, type)) {
                this.advanceAs(lexer, type);
            }
        } else {
            this.advanceAs(lexer, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean lookingAt(Lexer baseLexer, IElementType ... tokens) {
        LexerPosition position = baseLexer.getCurrentPosition();
        try {
            for (IElementType token : tokens) {
                baseLexer.advance();
                XPathLexer.skipWhitespaceAnComments(baseLexer);
                if (baseLexer.getTokenType() == token) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            baseLexer.restore(position);
        }
    }

    private static void skipWhitespaceAnComments(Lexer baseLexer) {
        while (WS_OR_COMMENT.contains(baseLexer.getTokenType())) {
            baseLexer.advance();
        }
    }

    public static Lexer create(boolean xpath2Syntax) {
        return new XPathLexer(xpath2Syntax);
    }
}

