/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.context.ContextProvider;
import org.intellij.lang.xpath.context.NamespaceContext;
import org.intellij.lang.xpath.psi.PrefixReference;
import org.intellij.lang.xpath.psi.QNameElement;
import org.intellij.lang.xpath.psi.XPathNodeTest;
import org.intellij.lang.xpath.psi.impl.PrefixedNameImpl;
import org.intellij.lang.xpath.psi.impl.ReferenceBase;
import org.intellij.lang.xpath.psi.impl.XPathChangeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PrefixReferenceImpl
extends ReferenceBase
implements PrefixReference {
    public PrefixReferenceImpl(QNameElement element, ASTNode nameNode) {
        super(element, nameNode);
    }

    @Override
    @Nullable
    public PsiElement resolve() {
        ContextProvider provider = this.getElement().getXPathContext();
        NamespaceContext namespaceContext = provider.getNamespaceContext();
        if (namespaceContext != null) {
            return namespaceContext.resolve(this.getCanonicalText(), provider.getContextElement());
        }
        return null;
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        XPathNodeTest expr = (XPathNodeTest)XPathChangeUtil.createExpression(this.getElement(), newElementName + ":x").getFirstChild().getChildren()[1];
        ASTNode nameNode = this.getNameNode();
        nameNode.getTreeParent().replaceChild(nameNode, ((PrefixedNameImpl)expr.getQName()).getPrefixNode());
        return this.getElement();
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/PrefixReferenceImpl", "getVariants"));
        }
        return EMPTY_ARRAY;
    }

    @Override
    public boolean isSoft() {
        if ("*".equals(this.getPrefix())) {
            return true;
        }
        ContextProvider context = this.getElement().getXPathContext();
        if (context instanceof ContextProvider.DefaultProvider) {
            return true;
        }
        return !this.canResolve();
    }

    @Override
    public String getPrefix() {
        return this.getCanonicalText();
    }

    @Override
    public boolean isUnresolved() {
        if (!this.canResolve()) {
            return true;
        }
        if (this.resolve() != null) {
            return false;
        }
        ContextProvider provider = this.getElement().getXPathContext();
        NamespaceContext namespaceContext = provider.getNamespaceContext();
        assert (namespaceContext != null);
        String prefix = this.getCanonicalText();
        return !namespaceContext.getKnownPrefixes(provider.getContextElement()).contains(prefix);
    }

    private boolean canResolve() {
        NamespaceContext namespaceContext = this.getElement().getXPathContext().getNamespaceContext();
        return namespaceContext != null && !"xml".equals(this.getCanonicalText());
    }
}

