/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import javax.xml.namespace.QName;
import org.intellij.lang.xpath.XPathTokenTypes;
import org.intellij.lang.xpath.psi.PrefixedName;
import org.intellij.lang.xpath.psi.XPath2ElementVisitor;
import org.intellij.lang.xpath.psi.XPath2Type;
import org.intellij.lang.xpath.psi.XPath2TypeElement;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.psi.impl.PrefixReferenceImpl;
import org.intellij.lang.xpath.psi.impl.PrefixedNameImpl;
import org.intellij.lang.xpath.psi.impl.XPath2ElementImpl;
import org.jetbrains.annotations.NotNull;

public class XPath2TypeElementImpl
extends XPath2ElementImpl
implements XPath2TypeElement {
    public XPath2TypeElementImpl(ASTNode node) {
        super(node);
    }

    @Override
    public XPathType getDeclaredType() {
        String prefix;
        PrefixedName qn;
        QName qName = this.getXPathContext().getQName(this);
        XPath2Type type = qName != null ? XPath2Type.fromName(qName) : ((qn = this.getQName()) != null ? ((prefix = qn.getPrefix()) != null && prefix.equals("xs") ? XPath2Type.fromName(new QName("http://www.w3.org/2001/XMLSchema", qn.getLocalName())) : null) : null);
        return type != null ? type : XPathType.UNKNOWN;
    }

    @Override
    public PrefixedName getQName() {
        ASTNode[] nodes = this.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{XPathTokenTypes.NCNAME}));
        if (nodes.length == 0) {
            ASTNode node = this.getNode().findChildByType(XPathTokenTypes.STAR);
            if (node != null) {
                return new PrefixedNameImpl(null, node);
            }
        } else {
            if (nodes.length == 1) {
                return new PrefixedNameImpl(nodes[0]);
            }
            if (nodes.length == 2) {
                return new PrefixedNameImpl(nodes[0], nodes[1]);
            }
        }
        return null;
    }

    @NotNull
    public PsiReference[] getReferences() {
        PrefixedName prefixedName = this.getQName();
        if (prefixedName != null && prefixedName.getPrefix() != null) {
            PsiReference[] psiReferenceArray;
            Object[] references = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, (PsiReferenceService.Hints)PsiReferenceService.Hints.NO_HINTS);
            PrefixReferenceImpl reference = new PrefixReferenceImpl(this, ((PrefixedNameImpl)prefixedName).getPrefixNode());
            if (references.length > 0) {
                psiReferenceArray = (PsiReference[])ArrayUtil.append((Object[])references, (Object)reference);
            } else {
                PsiReference[] psiReferenceArray2 = new PsiReference[1];
                psiReferenceArray = psiReferenceArray2;
                psiReferenceArray2[0] = reference;
            }
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/XPath2TypeElementImpl", "getReferences"));
            }
            return psiReferenceArray;
        }
        PsiReference[] psiReferenceArray = super.getReferences();
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/XPath2TypeElementImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    public void accept(XPath2ElementVisitor visitor) {
        visitor.visitXPath2TypeElement(this);
    }
}

