/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.context;

import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.intellij.lang.xpath.context.ContextType;
import org.intellij.lang.xpath.context.functions.DefaultFunctionContext;
import org.intellij.lang.xpath.context.functions.Function;
import org.intellij.lang.xpath.context.functions.FunctionContext;
import org.intellij.lang.xpath.context.functions.FunctionDeclarationParsing;
import org.intellij.lang.xpath.context.functions.FunctionImpl;
import org.intellij.lang.xpath.context.functions.Parameter;
import org.intellij.lang.xpath.psi.XPath2Type;
import org.intellij.lang.xpath.xslt.context.Xslt2ContextProvider;

public class Xslt2FunctionContext
extends DefaultFunctionContext {
    protected static final Map<Pair<QName, Integer>, Function> XSLT2_FUNCTIONS;
    private static final Factory<FunctionContext> FACTORY;

    protected Xslt2FunctionContext() {
        super(Xslt2ContextProvider.TYPE);
    }

    @Override
    protected Map<Pair<QName, Integer>, Function> createFunctionMap(ContextType contextType) {
        return ContainerUtil.union(XSLT2_FUNCTIONS, super.createFunctionMap(contextType));
    }

    @Override
    public boolean allowsExtensions() {
        return true;
    }

    @Override
    public Function resolve(QName name, int argCount) {
        if (name.getNamespaceURI().length() == 0) {
            name = new QName("http://www.w3.org/2005/xpath-functions", name.getLocalPart());
        }
        return super.resolve(name, argCount);
    }

    public static FunctionContext getInstance() {
        return Xslt2FunctionContext.getInstance(Xslt2ContextProvider.TYPE, FACTORY);
    }

    public static void main(String[] args) {
    }

    static {
        FACTORY = new Factory<FunctionContext>(){

            public FunctionContext create() {
                return new Xslt2FunctionContext();
            }
        };
        HashMap<Pair<QName, Integer>, Function> decls = new HashMap<Pair<QName, Integer>, Function>();
        FunctionDeclarationParsing.addFunction(decls, "function-available($function-name as xs:string) as xs:boolean ");
        FunctionDeclarationParsing.addFunction(decls, "function-available($function-name as xs:string, $arity as xs:integer) as xs:boolean");
        FunctionDeclarationParsing.addFunction(decls, "type-available($type-name as xs:string) as xs:boolean ");
        FunctionDeclarationParsing.addFunction(decls, "element-available($element-name as xs:string) as xs:boolean ");
        FunctionDeclarationParsing.addFunction(decls, "current() as item() ");
        FunctionDeclarationParsing.addFunction(decls, "current-group() as item()* ");
        FunctionDeclarationParsing.addFunction(decls, "current-grouping-key() as xs:anyAtomicType? ");
        FunctionDeclarationParsing.addFunction(decls, "regex-group($group-number as xs:integer) as xs:string ");
        FunctionDeclarationParsing.addFunction(decls, "unparsed-entity-uri($entity-name as xs:string) as xs:anyURI ");
        FunctionDeclarationParsing.addFunction(decls, "unparsed-entity-public-id($entity-name as xs:string) as xs:string ");
        FunctionDeclarationParsing.addFunction(decls, "generate-id() as xs:string ");
        FunctionDeclarationParsing.addFunction(decls, "generate-id($node as node()?) as xs:string ");
        FunctionDeclarationParsing.addFunction(decls, "system-property($property-name as xs:string) as xs:string ");
        FunctionDeclarationParsing.addFunction(decls, "document($uri-sequence as item()*) as node()*");
        FunctionDeclarationParsing.addFunction(decls, "document($uri-sequence as item()*, $base-node as node()) as node()*");
        FunctionDeclarationParsing.addFunction(decls, "unparsed-text($href as xs:string?) as xs:string?");
        FunctionDeclarationParsing.addFunction(decls, "unparsed-text($href as xs:string?, $encoding as xs:string) as xs:string?");
        FunctionDeclarationParsing.addFunction(decls, "unparsed-text-available($href as xs:string?) as xs:boolean");
        FunctionDeclarationParsing.addFunction(decls, "unparsed-text-available($href as xs:string?, $encoding as xs:string?) as xs:boolean");
        FunctionDeclarationParsing.addFunction(decls, "key($key-name as xs:string, $key-value as xs:anyAtomicType*) as node()* ");
        FunctionDeclarationParsing.addFunction(decls, "key($key-name as xs:string, $key-value as xs:anyAtomicType*, $top as node()) as node()*");
        FunctionDeclarationParsing.addFunction(decls, "format-number($value as numeric?, $picture as xs:string) as xs:string ");
        FunctionDeclarationParsing.addFunction(decls, "format-number($value as numeric?, $picture as xs:string, $decimal-format-name as xs:string) as xs:string");
        FunctionDeclarationParsing.addFunction(decls, "format-dateTime($value  as xs:dateTime?, $picture as xs:string) as xs:string? ");
        FunctionDeclarationParsing.addFunction(decls, "format-dateTime($value \t as xs:dateTime?,\n$picture as xs:string,\n$language as xs:string?,\n$calendar as xs:string?,\n$country as xs:string?) as xs:string?");
        FunctionDeclarationParsing.addFunction(decls, "format-time($value as xs:time?, $picture as xs:string) as xs:string? ");
        FunctionDeclarationParsing.addFunction(decls, "format-time($value \t as xs:time?,\n$picture as xs:string,\n$language as xs:string?,\n$calendar as xs:string?,\n$country as xs:string?) as xs:string?");
        FunctionDeclarationParsing.addFunction(decls, "format-date($value as xs:date?, $picture as xs:string) as xs:string? ");
        FunctionDeclarationParsing.addFunction(decls, "format-date($value \t as xs:date?,\n$picture as xs:string,\n$language as xs:string?,\n$calendar as xs:string?,\n$country as xs:string?) as xs:string?");
        Parameter optional_string = new Parameter(XPath2Type.STRING, Parameter.Kind.OPTIONAL);
        Parameter required_string = new Parameter(XPath2Type.STRING, Parameter.Kind.REQUIRED);
        Parameter required_nodeset = new Parameter(XPath2Type.NODE_SEQUENCE, Parameter.Kind.REQUIRED);
        Parameter required_any = new Parameter(XPath2Type.ITEM, Parameter.Kind.REQUIRED);
        Parameter optional_any = new Parameter(XPath2Type.ITEM, Parameter.Kind.OPTIONAL);
        Parameter any_list = new Parameter(XPath2Type.ITEM, Parameter.Kind.VARARG);
        Xslt2FunctionContext.addFunction(decls, "http://saxon.sf.net/", new FunctionImpl("dayTimeDuration-from-seconds", XPath2Type.DAYTIMEDURATION, new Parameter(XPath2Type.INTEGER, Parameter.Kind.REQUIRED)));
        Xslt2FunctionContext.addFunction(decls, "http://saxon.sf.net/", new FunctionImpl("yearMonthDuration-from-months", XPath2Type.YEARMONTHDURATION, new Parameter(XPath2Type.INTEGER, Parameter.Kind.REQUIRED)));
        Xslt2FunctionContext.addFunction(decls, "http://saxon.sf.net/", new FunctionImpl("distinct", XPath2Type.NODE_SEQUENCE, required_nodeset, optional_any));
        Xslt2FunctionContext.addFunction(decls, "http://saxon.sf.net/", new FunctionImpl("eval", XPath2Type.ITEM, required_any));
        Xslt2FunctionContext.addFunction(decls, "http://saxon.sf.net/", new FunctionImpl("evaluate", XPath2Type.ITEM, required_string, any_list));
        Xslt2FunctionContext.addFunction(decls, "http://saxon.sf.net/", new FunctionImpl("expression", XPath2Type.ITEM, required_string, any_list));
        Xslt2FunctionContext.addFunction(decls, "http://saxon.sf.net/", new FunctionImpl("get-pseudo-attribute", XPath2Type.ITEM, required_string));
        Xslt2FunctionContext.addFunction(decls, "http://saxon.sf.net/", new FunctionImpl("has-same-nodes", XPath2Type.BOOLEAN, required_nodeset, required_nodeset));
        Xslt2FunctionContext.addFunction(decls, "http://saxon.sf.net/", new FunctionImpl("highest", XPath2Type.NODE_SEQUENCE, required_nodeset, optional_any));
        Xslt2FunctionContext.addFunction(decls, "http://saxon.sf.net/", new FunctionImpl("leading", XPath2Type.NODE_SEQUENCE, required_nodeset, required_any));
        Xslt2FunctionContext.addFunction(decls, "http://saxon.sf.net/", new FunctionImpl("line-number", XPath2Type.INTEGER, new Parameter[0]));
        Xslt2FunctionContext.addFunction(decls, "http://saxon.sf.net/", new FunctionImpl("max", XPath2Type.NUMERIC, required_nodeset, optional_any));
        Xslt2FunctionContext.addFunction(decls, "http://saxon.sf.net/", new FunctionImpl("min", XPath2Type.NUMERIC, required_string));
        Xslt2FunctionContext.addFunction(decls, "http://saxon.sf.net/", new FunctionImpl("parse", XPath2Type.NODE_SEQUENCE, required_nodeset, optional_any));
        Xslt2FunctionContext.addFunction(decls, "http://saxon.sf.net/", new FunctionImpl("path", XPath2Type.STRING, new Parameter[0]));
        Xslt2FunctionContext.addFunction(decls, "http://saxon.sf.net/", new FunctionImpl("serialize", XPath2Type.STRING, required_nodeset, required_string));
        Xslt2FunctionContext.addFunction(decls, "http://saxon.sf.net/", new FunctionImpl("sum", XPath2Type.NUMERIC, required_nodeset, optional_any));
        Xslt2FunctionContext.addFunction(decls, "http://saxon.sf.net/", new FunctionImpl("systemId", XPath2Type.STRING, new Parameter[0]));
        Xslt2FunctionContext.addFunction(decls, "http://saxon.sf.net/", new FunctionImpl("tokenize", XPath2Type.NODE_SEQUENCE, required_string, optional_string));
        XSLT2_FUNCTIONS = Collections.unmodifiableMap(decls);
    }
}

