/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.context;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.List;
import org.intellij.lang.xpath.context.VariableContext;
import org.intellij.lang.xpath.psi.XPathElement;
import org.intellij.lang.xpath.psi.XPathVariable;
import org.intellij.lang.xpath.psi.XPathVariableReference;
import org.intellij.lang.xpath.psi.impl.ResolveUtil;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.impl.XsltIncludeIndex;
import org.intellij.lang.xpath.xslt.psi.XsltElementFactory;
import org.intellij.lang.xpath.xslt.psi.XsltParameter;
import org.intellij.lang.xpath.xslt.psi.XsltTemplate;
import org.intellij.lang.xpath.xslt.psi.XsltVariable;
import org.intellij.lang.xpath.xslt.quickfix.CreateParameterFix;
import org.intellij.lang.xpath.xslt.quickfix.CreateVariableFix;
import org.intellij.lang.xpath.xslt.util.ElementProcessor;
import org.intellij.lang.xpath.xslt.util.XsltCodeInsightUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XsltVariableContext
implements VariableContext<XsltVariable> {
    public static final XsltVariableContext INSTANCE = new XsltVariableContext();
    private final ResolveCache.Resolver RESOLVER = new ResolveCache.Resolver(){

        @Nullable
        public PsiElement resolve(@NotNull PsiReference psiReference, boolean incompleteCode) {
            if (psiReference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiReference", "org/intellij/lang/xpath/xslt/context/XsltVariableContext$1", "resolve"));
            }
            return XsltVariableContext.this.resolveInner((XPathVariableReference)psiReference);
        }
    };

    @NotNull
    public XsltVariable[] getVariablesInScope(XPathElement element) {
        XmlTag context = this.getContextTagImpl(element);
        VariantsProcessor processor = new VariantsProcessor(context);
        ResolveUtil.treeWalkUp(processor, (PsiElement)context);
        XsltVariableContext.processForwardGlobals(context, processor);
        XsltVariable[] xsltVariableArray = processor.getResult();
        if (xsltVariableArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/context/XsltVariableContext", "getVariablesInScope"));
        }
        return xsltVariableArray;
    }

    @Override
    public XPathVariable resolve(XPathVariableReference reference) {
        return (XPathVariable)ResolveCache.getInstance((Project)reference.getProject()).resolveWithCaching((PsiReference)reference, (ResolveCache.AbstractResolver)this.RESOLVER, false, false);
    }

    @Nullable
    private XPathVariable resolveInner(XPathVariableReference reference) {
        XmlFile file;
        final XmlTag context = this.getContextTagImpl(reference);
        final VariableResolveProcessor processor = new VariableResolveProcessor(reference.getReferencedName(), context);
        XPathVariable variable = (XPathVariable)ResolveUtil.treeWalkUp(processor, (PsiElement)context);
        if (variable != null) {
            return variable;
        }
        if (!XsltVariableContext.processForwardGlobals(context, processor) && (file = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)context, XmlFile.class, (boolean)true)) != null) {
            XsltIncludeIndex.processBackwardDependencies(file, new Processor<XmlFile>(){

                public boolean process(XmlFile xmlFile) {
                    processor.processExternalFile((PsiFile)xmlFile, context);
                    return processor.shouldContinue();
                }
            });
        }
        return (XPathVariable)processor.getResult();
    }

    private static boolean processForwardGlobals(XmlTag context, VariableProcessor processor) {
        while (context != null && !XsltSupport.isTopLevelElement(context)) {
            context = context.getParentTag();
        }
        while (context != null && processor.shouldContinue()) {
            processor.process(context);
            context = (XmlTag)PsiTreeUtil.getNextSiblingOfType((PsiElement)context, XmlTag.class);
        }
        return !processor.shouldContinue();
    }

    @Nullable
    protected XmlTag getContextTagImpl(XPathElement element) {
        return (XmlTag)PsiTreeUtil.getContextOfType((PsiElement)element, XmlTag.class, (boolean)true);
    }

    @Override
    @NotNull
    public IntentionAction[] getUnresolvedVariableFixes(XPathVariableReference reference) {
        IntentionAction[] intentionActionArray = new IntentionAction[]{new CreateVariableFix(reference), new CreateParameterFix(reference)};
        if (intentionActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/context/XsltVariableContext", "getUnresolvedVariableFixes"));
        }
        return intentionActionArray;
    }

    @Override
    public boolean isReferenceTo(PsiElement element, XPathVariableReference reference) {
        if (element instanceof XsltParameter) {
            PsiReference[] references;
            XsltTemplate template = XsltCodeInsightUtil.getTemplate(element, false);
            if (template == null || template.getMatchExpression() == null) {
                return false;
            }
            XPathVariable t = reference.resolve();
            for (PsiReference r : references = element.getReferences()) {
                if (!r.isReferenceTo((PsiElement)t)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canResolve() {
        return true;
    }

    static class VariableResolveProcessor
    extends VariableProcessor
    implements ResolveUtil.ResolveProcessor {
        private final String myName;
        private PsiElement myResult = null;

        public VariableResolveProcessor(String name, XmlTag context) {
            super(context);
            this.myName = name;
        }

        @Override
        public PsiElement getResult() {
            return this.myResult;
        }

        @Override
        protected boolean shouldContinue() {
            return this.myResult == null;
        }

        @Override
        protected void processVarOrParamImpl(XmlTag tag) {
            String name;
            if (XsltSupport.isVariableOrParam(tag) && this.myName.equals(name = tag.getAttributeValue("name"))) {
                this.myResult = XsltElementFactory.getInstance().wrapElement(tag, XsltVariable.class);
            }
        }
    }

    static class VariantsProcessor
    extends VariableProcessor {
        private final List<XsltVariable> myNames = new ArrayList<XsltVariable>();

        public VariantsProcessor(XmlTag context) {
            super(context);
        }

        public XsltVariable[] getResult() {
            return this.myNames.toArray(new XsltVariable[this.myNames.size()]);
        }

        @Override
        protected void processVarOrParamImpl(XmlTag tag) {
            if (XsltSupport.isVariableOrParam(tag)) {
                this.myNames.add(XsltElementFactory.getInstance().wrapElement(tag, XsltVariable.class));
            }
        }

        @Override
        protected boolean shouldContinue() {
            return true;
        }
    }

    static abstract class VariableProcessor
    extends ElementProcessor<XmlTag> {
        public VariableProcessor(XmlTag context) {
            super(context);
        }

        @Override
        protected boolean followImport() {
            return true;
        }

        @Override
        protected final void processTemplate(XmlTag tag) {
        }

        protected abstract void processVarOrParamImpl(XmlTag var1);

        @Override
        protected final void processVarOrParam(XmlTag tag) {
            if (tag != this.myRoot) {
                this.processVarOrParamImpl(tag);
            }
        }

        @Override
        protected abstract boolean shouldContinue();
    }
}

