/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import org.intellij.lang.xpath.psi.impl.ResolveUtil;
import org.intellij.lang.xpath.xslt.impl.references.SimpleAttributeReference;
import org.jetbrains.annotations.NotNull;

class AttributeReference
extends SimpleAttributeReference {
    private final boolean mySoft;
    final ResolveUtil.Matcher myMatcher;

    public AttributeReference(XmlAttribute source, ResolveUtil.Matcher matcher, boolean soft) {
        super(source);
        this.myMatcher = matcher;
        this.mySoft = soft;
    }

    @NotNull
    public Object[] getVariants() {
        Object[] objectArray = ResolveUtil.collect(this.myMatcher.variantMatcher());
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/references/AttributeReference", "getVariants"));
        }
        return objectArray;
    }

    @Override
    @NotNull
    protected TextRange getTextRange() {
        TextRange textRange = TextRange.from((int)0, (int)this.myAttribute.getValue().length());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/references/AttributeReference", "getTextRange"));
        }
        return textRange;
    }

    public boolean isSoft() {
        return this.mySoft;
    }

    @Override
    protected PsiElement resolveImpl() {
        return ResolveUtil.resolve(this.myMatcher);
    }
}

