/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.psi.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import org.intellij.lang.xpath.psi.impl.ResolveUtil;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.psi.XsltFunction;
import org.intellij.lang.xpath.xslt.psi.XsltParameter;
import org.intellij.lang.xpath.xslt.psi.XsltStylesheet;
import org.intellij.lang.xpath.xslt.psi.XsltTemplate;
import org.intellij.lang.xpath.xslt.psi.XsltVariable;
import org.intellij.lang.xpath.xslt.psi.impl.XsltElementImpl;
import org.intellij.lang.xpath.xslt.util.IncludeAwareMatcher;
import org.intellij.lang.xpath.xslt.util.ParamMatcher;
import org.intellij.lang.xpath.xslt.util.TemplateMatcher;
import org.jetbrains.annotations.NotNull;

public class XsltStylesheetImpl
extends XsltElementImpl
implements XsltStylesheet {
    public XsltStylesheetImpl(XmlTag target) {
        super(target);
    }

    @Override
    @NotNull
    public XsltParameter[] getParameters() {
        XsltParameter[] xsltParameterArray = XsltStylesheetImpl.convertArray(ResolveUtil.collect(new ParamMatcher(this.getTag(), null)), XsltParameter.class);
        if (xsltParameterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/psi/impl/XsltStylesheetImpl", "getParameters"));
        }
        return xsltParameterArray;
    }

    @Override
    @NotNull
    public XsltVariable[] getVariables() {
        XsltVariable[] xsltVariableArray = XsltStylesheetImpl.convertArray(ResolveUtil.collect(new ParamMatcher(this.getTag(), null){

            @Override
            protected boolean isApplicable(XmlTag tag) {
                return XsltSupport.isVariable(tag);
            }
        }), XsltVariable.class);
        if (xsltVariableArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/psi/impl/XsltStylesheetImpl", "getVariables"));
        }
        return xsltVariableArray;
    }

    @Override
    @NotNull
    public XsltTemplate[] getTemplates() {
        XmlDocument document = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)this.getTag(), XmlDocument.class);
        XsltTemplate[] xsltTemplateArray = XsltStylesheetImpl.convertArray(ResolveUtil.collect(new TemplateMatcher(document)), XsltTemplate.class);
        if (xsltTemplateArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/psi/impl/XsltStylesheetImpl", "getTemplates"));
        }
        return xsltTemplateArray;
    }

    @Override
    @NotNull
    public XsltFunction[] getFunctions() {
        XmlDocument document = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)this.getTag(), XmlDocument.class);
        XsltFunction[] xsltFunctionArray = XsltStylesheetImpl.convertArray(ResolveUtil.collect(new FunctionMatcher(document)), XsltFunction.class);
        if (xsltFunctionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/psi/impl/XsltStylesheetImpl", "getFunctions"));
        }
        return xsltFunctionArray;
    }

    public String toString() {
        return "XsltStylesheet";
    }

    private class FunctionMatcher
    extends IncludeAwareMatcher {
        public FunctionMatcher(XmlDocument document) {
            super(document);
        }

        @Override
        protected boolean matches(XmlTag element) {
            return XsltSupport.isFunction(element);
        }

        @Override
        protected ResolveUtil.Matcher changeDocument(XmlDocument document) {
            return new FunctionMatcher(document);
        }

        @Override
        public ResolveUtil.Matcher variantMatcher() {
            return new FunctionMatcher(this.myDocument);
        }
    }
}

