/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.quickfix;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.xslt.psi.XsltParameter;
import org.intellij.lang.xpath.xslt.psi.XsltTemplate;
import org.intellij.lang.xpath.xslt.quickfix.DeleteUnusedElementBase;
import org.intellij.lang.xpath.xslt.util.XsltCodeInsightUtil;
import org.jetbrains.annotations.NotNull;

public class DeleteUnusedParameterFix
extends DeleteUnusedElementBase<XsltParameter> {
    public DeleteUnusedParameterFix(String name, XsltParameter param) {
        super(name, param);
    }

    @Override
    public String getType() {
        return "Parameter";
    }

    @Override
    protected void deleteElement(@NotNull XsltParameter obj) throws IncorrectOperationException {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "org/intellij/lang/xpath/xslt/quickfix/DeleteUnusedParameterFix", "deleteElement"));
        }
        XsltTemplate template = XsltCodeInsightUtil.getTemplate((PsiElement)obj.getTag(), false);
        if (template == null || template.getMatchExpression() == null) {
            GlobalSearchScope searchScope = obj.getResolveScope();
            for (PsiReference reference : ReferencesSearch.search((PsiElement)obj, (SearchScope)searchScope, (boolean)false)) {
                XmlTag t = (XmlTag)PsiTreeUtil.getContextOfType((PsiElement)reference.getElement(), XmlTag.class, (boolean)true);
                if (t == null || !"http://www.w3.org/1999/XSL/Transform".equals(t.getNamespace())) continue;
                assert ("with-param".equals(t.getLocalName()));
                t.delete();
            }
        }
        super.deleteElement(obj);
    }
}

