/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.lang.properties.IProperty;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PropertiesAnchorizer {
    private static final Logger LOG = Logger.getInstance(PropertiesAnchorizer.class);
    private final Map<IProperty, PropertyAnchor> myAnchors = new HashMap();

    public PropertiesAnchorizer(Project project) {
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/properties/editor/PropertiesAnchorizer$1", "childRemoved"));
                }
                PsiElement removed = event.getChild();
                if (removed instanceof IProperty) {
                    PropertiesAnchorizer.this.myAnchors.remove(removed);
                }
            }
        });
    }

    @NotNull
    public PropertyAnchor get(IProperty property) {
        PropertyAnchor anchor = this.myAnchors.get(property);
        LOG.assertTrue(anchor != null);
        PropertyAnchor propertyAnchor = anchor;
        if (propertyAnchor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/PropertiesAnchorizer", "get"));
        }
        return propertyAnchor;
    }

    public PropertyAnchor createOrUpdate(Collection<IProperty> properties) {
        LOG.assertTrue(!properties.isEmpty());
        SmartList propertiesWithoutAnchor = new SmartList();
        PropertyAnchor representativeAnchor = null;
        for (IProperty property : properties) {
            PropertyAnchor anchor = this.myAnchors.get(property);
            if (anchor == null) {
                propertiesWithoutAnchor.add(property);
                continue;
            }
            if (representativeAnchor != null) {
                LOG.assertTrue(representativeAnchor == anchor);
            }
            representativeAnchor = anchor;
        }
        if (representativeAnchor == null) {
            LOG.assertTrue(propertiesWithoutAnchor.size() == properties.size());
            representativeAnchor = new PropertyAnchor(properties);
        } else {
            representativeAnchor.addProperties((Collection)propertiesWithoutAnchor);
        }
        for (IProperty property : propertiesWithoutAnchor) {
            this.myAnchors.put(property, representativeAnchor);
        }
        return representativeAnchor;
    }

    public static final class PropertyAnchor {
        private final Collection<IProperty> myProperties;

        public PropertyAnchor(Collection<IProperty> properties) {
            this.myProperties = new ArrayList<IProperty>(properties);
        }

        @NotNull
        public String getName() {
            String string = this.getRepresentative().getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/PropertiesAnchorizer$PropertyAnchor", "getName"));
            }
            return string;
        }

        @NotNull
        public IProperty getRepresentative() {
            IProperty iProperty = (IProperty)ContainerUtil.getFirstItem(this.myProperties);
            if (iProperty == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/PropertiesAnchorizer$PropertyAnchor", "getRepresentative"));
            }
            return iProperty;
        }

        public String toString() {
            return "PropertyAnchor:" + this.getName();
        }

        private void addProperties(Collection<IProperty> properties) {
            this.myProperties.addAll(properties);
        }
    }
}

