/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.structureView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.editor.PropertiesAnchorizer;
import com.intellij.lang.properties.editor.ResourceBundleEditorViewElement;
import com.intellij.lang.properties.editor.ResourceBundlePropertyStructureViewElement;
import com.intellij.lang.properties.structureView.PropertiesStructureViewElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesPrefixGroup
implements Group,
ResourceBundleEditorViewElement {
    private final Collection<TreeElement> myProperties;
    @NotNull
    private final String myPrefix;
    private final String myPresentableName;
    @NotNull
    private final String mySeparator;

    public PropertiesPrefixGroup(Collection<TreeElement> properties, @NotNull String prefix, String presentableName, @NotNull String separator) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/lang/properties/structureView/PropertiesPrefixGroup", "<init>"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/lang/properties/structureView/PropertiesPrefixGroup", "<init>"));
        }
        this.myProperties = properties;
        this.myPrefix = prefix;
        this.myPresentableName = presentableName;
        this.mySeparator = separator;
    }

    public String getPresentableName() {
        return this.myPresentableName;
    }

    @NotNull
    public String getSeparator() {
        String string = this.mySeparator;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/structureView/PropertiesPrefixGroup", "getSeparator"));
        }
        return string;
    }

    @NotNull
    public String getPrefix() {
        String string = this.myPrefix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/structureView/PropertiesPrefixGroup", "getPrefix"));
        }
        return string;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        ItemPresentation itemPresentation = new ItemPresentation(){

            public String getPresentableText() {
                return PropertiesPrefixGroup.this.myPresentableName;
            }

            public String getLocationString() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return AllIcons.Nodes.Advice;
            }
        };
        if (itemPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/structureView/PropertiesPrefixGroup", "getPresentation"));
        }
        return itemPresentation;
    }

    @NotNull
    public Collection<TreeElement> getChildren() {
        ArrayList<TreeElement> result = new ArrayList<TreeElement>();
        List prefixWords = StringUtil.split((String)this.myPrefix, (String)this.mySeparator);
        for (TreeElement treeElement : this.myProperties) {
            boolean startsWith;
            String key;
            if (!(treeElement instanceof StructureViewTreeElement)) continue;
            Object value = ((StructureViewTreeElement)treeElement).getValue();
            if (value instanceof PropertiesAnchorizer.PropertyAnchor) {
                value = ((PropertiesAnchorizer.PropertyAnchor)value).getRepresentative();
            }
            if (!(value instanceof IProperty) || (key = ((IProperty)value).getUnescapedKey()) == null) continue;
            if (!key.equals(this.myPrefix)) {
                List keyWords = StringUtil.split((String)key, (String)this.mySeparator);
                boolean bl = startsWith = prefixWords.size() < keyWords.size();
                if (startsWith) {
                    for (int i = 0; i < prefixWords.size(); ++i) {
                        String prefixWord = (String)prefixWords.get(i);
                        String keyWord = (String)keyWords.get(i);
                        if (Comparing.strEqual((String)keyWord, (String)prefixWord)) continue;
                        startsWith = false;
                        break;
                    }
                }
            } else {
                startsWith = true;
            }
            if (!startsWith) continue;
            result.add(treeElement);
            String presentableName = key.substring(this.myPrefix.length());
            presentableName = StringUtil.trimStart((String)presentableName, (String)this.mySeparator);
            if (treeElement instanceof PropertiesStructureViewElement) {
                ((PropertiesStructureViewElement)treeElement).setPresentableName(presentableName);
            }
            if (!(treeElement instanceof ResourceBundlePropertyStructureViewElement)) continue;
            ((ResourceBundlePropertyStructureViewElement)treeElement).setPresentableName(presentableName);
        }
        ArrayList<TreeElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/structureView/PropertiesPrefixGroup", "getChildren"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public IProperty[] getProperties() {
        List elements = ContainerUtil.mapNotNull(this.getChildren(), (Function)new NullableFunction<TreeElement, IProperty>(){

            @Nullable
            public IProperty fun(TreeElement treeElement) {
                if (treeElement instanceof PropertiesStructureViewElement) {
                    PropertiesStructureViewElement propertiesElement = (PropertiesStructureViewElement)treeElement;
                    return propertiesElement.getValue();
                }
                if (treeElement instanceof ResourceBundlePropertyStructureViewElement) {
                    return ((ResourceBundlePropertyStructureViewElement)treeElement).getProperties()[0];
                }
                return null;
            }
        });
        IProperty[] iPropertyArray = elements.toArray(new IProperty[elements.size()]);
        if (iPropertyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/structureView/PropertiesPrefixGroup", "getProperties"));
        }
        return iPropertyArray;
    }

    @Override
    @Nullable
    public PsiFile[] getFiles() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertiesPrefixGroup group = (PropertiesPrefixGroup)o;
        return this.myPrefix.equals(group.myPrefix);
    }

    public int hashCode() {
        return this.myPrefix.hashCode();
    }
}

