/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.DefaultExternalDependencyId;
import org.jetbrains.plugins.gradle.ExternalDependencyId;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ModelFactory;

public abstract class AbstractExternalDependency
implements ExternalDependency {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final DefaultExternalDependencyId myId;
    private String myScope;
    private Collection<ExternalDependency> myDependencies;
    private String mySelectionReason;
    private int myClasspathOrder;
    private boolean myExported;

    public AbstractExternalDependency() {
        this((ExternalDependencyId)new DefaultExternalDependencyId(), null, null);
    }

    public AbstractExternalDependency(ExternalDependencyId id, String selectionReason, Collection<ExternalDependency> dependencies) {
        this.myId = new DefaultExternalDependencyId(id);
        this.mySelectionReason = selectionReason;
        this.myDependencies = dependencies == null ? new ArrayList() : ModelFactory.createCopy(dependencies);
    }

    public AbstractExternalDependency(ExternalDependency dependency) {
        this(dependency.getId(), dependency.getSelectionReason(), dependency.getDependencies());
        this.myScope = dependency.getScope();
        this.myClasspathOrder = dependency.getClasspathOrder();
        this.myExported = dependency.getExported();
    }

    @NotNull
    public ExternalDependencyId getId() {
        DefaultExternalDependencyId defaultExternalDependencyId = this.myId;
        if (defaultExternalDependencyId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/AbstractExternalDependency", "getId"));
        }
        return defaultExternalDependencyId;
    }

    public String getName() {
        return this.myId.getName();
    }

    public void setName(String name) {
        this.myId.setName(name);
    }

    public String getGroup() {
        return this.myId.getGroup();
    }

    public void setGroup(String group) {
        this.myId.setGroup(group);
    }

    public String getVersion() {
        return this.myId.getVersion();
    }

    public void setVersion(String version) {
        this.myId.setVersion(version);
    }

    @NotNull
    public String getPackaging() {
        String string = this.myId.getPackaging();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/AbstractExternalDependency", "getPackaging"));
        }
        return string;
    }

    public void setPackaging(@NotNull String packaging) {
        if (packaging == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packaging", "org/jetbrains/plugins/gradle/model/AbstractExternalDependency", "setPackaging"));
        }
        this.myId.setPackaging(packaging);
    }

    @Nullable
    public String getClassifier() {
        return this.myId.getClassifier();
    }

    public void setClassifier(@Nullable String classifier) {
        this.myId.setClassifier(classifier);
    }

    @Nullable
    public String getSelectionReason() {
        return this.mySelectionReason;
    }

    public int getClasspathOrder() {
        return this.myClasspathOrder;
    }

    public void setClasspathOrder(int order) {
        this.myClasspathOrder = order;
    }

    public void setSelectionReason(String selectionReason) {
        this.mySelectionReason = selectionReason;
    }

    public String getScope() {
        return this.myScope;
    }

    public void setScope(String scope) {
        this.myScope = scope;
    }

    @NotNull
    public Collection<ExternalDependency> getDependencies() {
        Collection<ExternalDependency> collection = this.myDependencies;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/AbstractExternalDependency", "getDependencies"));
        }
        return collection;
    }

    public boolean getExported() {
        return this.myExported;
    }

    public void setExported(boolean exported) {
        this.myExported = exported;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractExternalDependency)) {
            return false;
        }
        AbstractExternalDependency that = (AbstractExternalDependency)o;
        return Objects.equal((Object)this.myId, (Object)that.myId) && Objects.equal((Object)this.myScope, (Object)that.myScope) && Objects.equal(this.myDependencies, that.myDependencies) && Objects.equal((Object)this.mySelectionReason, (Object)that.mySelectionReason);
    }

    public int hashCode() {
        return 31 + Objects.hashCode((Object[])new Object[]{this.myId, this.myScope, this.myDependencies, this.mySelectionReason});
    }
}

