/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import com.google.common.base.Objects;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.AbstractExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalMultiLibraryDependency;

public class DefaultExternalMultiLibraryDependency
extends AbstractExternalDependency
implements ExternalMultiLibraryDependency {
    private static final long serialVersionUID = 1L;
    private Collection<File> files = new LinkedHashSet<File>();
    private Collection<File> sources = new LinkedHashSet<File>();
    private Collection<File> javadocs = new LinkedHashSet<File>();

    public DefaultExternalMultiLibraryDependency() {
    }

    public DefaultExternalMultiLibraryDependency(ExternalMultiLibraryDependency dependency) {
        super((ExternalDependency)dependency);
        this.files = dependency.getFiles();
        this.sources = dependency.getSources();
        this.javadocs = dependency.getJavadoc();
    }

    @NotNull
    public Collection<File> getFiles() {
        Collection<File> collection = this.files;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/DefaultExternalMultiLibraryDependency", "getFiles"));
        }
        return collection;
    }

    @NotNull
    public Collection<File> getSources() {
        Collection<File> collection = this.sources;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/DefaultExternalMultiLibraryDependency", "getSources"));
        }
        return collection;
    }

    @NotNull
    public Collection<File> getJavadoc() {
        Collection<File> collection = this.javadocs;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/DefaultExternalMultiLibraryDependency", "getJavadoc"));
        }
        return collection;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultExternalMultiLibraryDependency)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultExternalMultiLibraryDependency that = (DefaultExternalMultiLibraryDependency)o;
        return Objects.equal(this.files, that.files);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.files});
    }

    public String toString() {
        return "library '" + this.files + '\'';
    }
}

