/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.ClasspathEntryModel;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalMultiLibraryDependency;
import org.jetbrains.plugins.gradle.model.FileCollectionDependency;
import org.jetbrains.plugins.gradle.tooling.ErrorMessageBuilder;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.internal.BuildScriptClasspathModelImpl;
import org.jetbrains.plugins.gradle.tooling.internal.ClasspathEntryModelImpl;
import org.jetbrains.plugins.gradle.tooling.util.DependencyResolverImpl;
import org.jetbrains.plugins.gradle.tooling.util.DependencyTraverser;

public class ModelBuildScriptClasspathBuilderImpl
implements ModelBuilderService {
    private static final String CLASSPATH_CONFIGURATION_NAME = "classpath";
    private final Map<String, BuildScriptClasspathModelImpl> cache = new ConcurrentHashMap<String, BuildScriptClasspathModelImpl>();

    public boolean canBuild(String modelName) {
        return BuildScriptClasspathModel.class.getName().equals(modelName);
    }

    @Nullable
    public Object buildAll(String modelName, Project project) {
        Configuration classpathConfiguration;
        BuildScriptClasspathModelImpl parentBuildScriptClasspath;
        Project parent;
        BuildScriptClasspathModelImpl buildScriptClasspath = this.cache.get(project.getPath());
        if (buildScriptClasspath != null) {
            return buildScriptClasspath;
        }
        buildScriptClasspath = new BuildScriptClasspathModelImpl();
        File gradleHomeDir = project.getGradle().getGradleHomeDir();
        buildScriptClasspath.setGradleHomeDir(gradleHomeDir);
        buildScriptClasspath.setGradleVersion(GradleVersion.current().getVersion());
        boolean downloadJavadoc = false;
        boolean downloadSources = true;
        IdeaPlugin ideaPlugin = (IdeaPlugin)project.getPlugins().findPlugin(IdeaPlugin.class);
        if (ideaPlugin != null) {
            IdeaModule ideaModule = ideaPlugin.getModel().getModule();
            downloadJavadoc = ideaModule.isDownloadJavadoc();
            downloadSources = ideaModule.isDownloadSources();
        }
        if ((parent = project.getParent()) != null && (parentBuildScriptClasspath = (BuildScriptClasspathModelImpl)this.buildAll(modelName, parent)) != null) {
            for (ClasspathEntryModel classpathEntryModel : parentBuildScriptClasspath.getClasspath()) {
                buildScriptClasspath.add(classpathEntryModel);
            }
        }
        if ((classpathConfiguration = (Configuration)project.getBuildscript().getConfigurations().findByName(CLASSPATH_CONFIGURATION_NAME)) == null) {
            return null;
        }
        Collection<ExternalDependency> dependencies = new DependencyResolverImpl(project, false, downloadJavadoc, downloadSources).resolveDependencies(classpathConfiguration);
        for (ExternalDependency dependency : new DependencyTraverser(dependencies)) {
            if (dependency instanceof ExternalLibraryDependency) {
                ExternalLibraryDependency libraryDep = (ExternalLibraryDependency)dependency;
                buildScriptClasspath.add(new ClasspathEntryModelImpl(ModelBuildScriptClasspathBuilderImpl.pathSet(libraryDep.getFile()), ModelBuildScriptClasspathBuilderImpl.pathSet(libraryDep.getSource()), ModelBuildScriptClasspathBuilderImpl.pathSet(libraryDep.getJavadoc())));
            }
            if (dependency instanceof ExternalMultiLibraryDependency) {
                ExternalMultiLibraryDependency multiLibraryDependency = (ExternalMultiLibraryDependency)dependency;
                buildScriptClasspath.add(new ClasspathEntryModelImpl(ModelBuildScriptClasspathBuilderImpl.pathSet(multiLibraryDependency.getFiles()), ModelBuildScriptClasspathBuilderImpl.pathSet(multiLibraryDependency.getSources()), ModelBuildScriptClasspathBuilderImpl.pathSet(multiLibraryDependency.getJavadoc())));
            }
            if (!(dependency instanceof FileCollectionDependency)) continue;
            FileCollectionDependency fileCollectionDependency = (FileCollectionDependency)dependency;
            buildScriptClasspath.add(new ClasspathEntryModelImpl(ModelBuildScriptClasspathBuilderImpl.pathSet(fileCollectionDependency.getFiles()), new HashSet<String>(), new HashSet<String>()));
        }
        this.cache.put(project.getPath(), buildScriptClasspath);
        return buildScriptClasspath;
    }

    @NotNull
    public ErrorMessageBuilder getErrorMessageBuilder(@NotNull Project project, @NotNull Exception e) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/tooling/builder/ModelBuildScriptClasspathBuilderImpl", "getErrorMessageBuilder"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/gradle/tooling/builder/ModelBuildScriptClasspathBuilderImpl", "getErrorMessageBuilder"));
        }
        ErrorMessageBuilder errorMessageBuilder = ErrorMessageBuilder.create((Project)project, (Exception)e, (String)"Project build classpath resolve errors").withDescription("Unable to resolve additional buildscript classpath dependencies");
        if (errorMessageBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/tooling/builder/ModelBuildScriptClasspathBuilderImpl", "getErrorMessageBuilder"));
        }
        return errorMessageBuilder;
    }

    private static Set<String> pathSet(Collection<File> files) {
        HashSet<String> set = new HashSet<String>();
        for (File file : files) {
            if (file == null) continue;
            set.add(file.getPath());
        }
        return set;
    }

    private static Set<String> pathSet(File ... files) {
        return ModelBuildScriptClasspathBuilderImpl.pathSet(Arrays.asList(files));
    }
}

