/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.EditorSchemeAttributeDescriptor;
import com.intellij.application.options.colors.highlighting.HighlightData;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.CaretAdapter;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.ScrollingUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import org.intellij.lang.annotations.JdkConstants;

public class ClickNavigator {
    private final JList myOptionsList;

    public ClickNavigator(JList optionsList) {
        this.myOptionsList = optionsList;
    }

    public void addClickNavigatorToGeneralView(final Editor view) {
        view.getContentComponent().addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                EditorUtil.setHandCursor(view);
            }
        });
        CaretAdapter listener2 = new CaretAdapter(){

            public void caretPositionChanged(CaretEvent e) {
                ClickNavigator.this.setSelectedItem(HighlighterColors.TEXT.getExternalName(), true);
            }
        };
        view.getCaretModel().addCaretListener((CaretListener)listener2);
    }

    private boolean setSelectedItem(String type, boolean select) {
        DefaultListModel model = (DefaultListModel)this.myOptionsList.getModel();
        for (int i = 0; i < model.size(); ++i) {
            Object o = model.get(i);
            if (!(o instanceof EditorSchemeAttributeDescriptor) || !type.equals(((EditorSchemeAttributeDescriptor)o).getType())) continue;
            if (select) {
                ScrollingUtil.selectItem((JList)this.myOptionsList, (int)i);
            }
            return true;
        }
        return false;
    }

    private static boolean isWhiteSpace(int offset, CharSequence text) {
        return offset <= 0 || offset >= text.length() || text.charAt(offset) == ' ' || text.charAt(offset) == '\t' || text.charAt(offset) == '\n' || text.charAt(offset) == '\r';
    }

    public static boolean highlightDataContainsOffset(HighlightData data, int offset) {
        return offset >= data.getStartOffset() && offset <= data.getEndOffset();
    }

    public void addClickNavigator(final Editor view, final SyntaxHighlighter highlighter, final HighlightData[] data, final boolean isBackgroundImportant) {
        this.addMouseMotionListener(view, highlighter, data, isBackgroundImportant);
        CaretAdapter listener2 = new CaretAdapter(){

            public void caretPositionChanged(CaretEvent e) {
                ClickNavigator.this.navigate(view, true, e.getNewPosition(), highlighter, data, isBackgroundImportant);
            }
        };
        view.getCaretModel().addCaretListener((CaretListener)listener2);
    }

    private boolean selectItem(boolean select, HighlighterIterator itr, SyntaxHighlighter highlighter) {
        IElementType tokenType = itr.getTokenType();
        if (tokenType == null) {
            return false;
        }
        String type = ClickNavigator.highlightingTypeFromTokenType(tokenType, highlighter);
        return this.setSelectedItem(type, select);
    }

    public static String highlightingTypeFromTokenType(IElementType tokenType, SyntaxHighlighter highlighter) {
        TextAttributesKey[] highlights = highlighter.getTokenHighlights(tokenType);
        String s = null;
        for (int i = highlights.length - 1; i >= 0; --i) {
            if (highlights[i] == HighlighterColors.TEXT) continue;
            s = highlights[i].getExternalName();
            break;
        }
        return s == null ? HighlighterColors.TEXT.getExternalName() : s;
    }

    private void addMouseMotionListener(final Editor view, final SyntaxHighlighter highlighter, final HighlightData[] data, final boolean isBackgroundImportant) {
        view.getContentComponent().addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                LogicalPosition pos = view.xyToLogicalPosition(new Point(e.getX(), e.getY()));
                ClickNavigator.this.navigate(view, false, pos, highlighter, data, isBackgroundImportant);
            }
        });
    }

    private void navigate(Editor editor, boolean select, LogicalPosition pos, SyntaxHighlighter highlighter, HighlightData[] data, boolean isBackgroundImportant) {
        int offset = editor.logicalPositionToOffset(pos);
        if (!isBackgroundImportant && editor.offsetToLogicalPosition((int)offset).column != pos.column && !select) {
            ClickNavigator.setCursor(editor, 2);
            return;
        }
        if (data != null) {
            for (HighlightData highlightData : data) {
                if (!ClickNavigator.highlightDataContainsOffset(highlightData, editor.logicalPositionToOffset(pos))) continue;
                if (!select) {
                    ClickNavigator.setCursor(editor, 12);
                }
                this.setSelectedItem(highlightData.getHighlightType(), select);
                return;
            }
        }
        if (highlighter != null) {
            HighlighterIterator itr = ((EditorEx)editor).getHighlighter().createIterator(offset);
            boolean selection = this.selectItem(select, itr, highlighter);
            if (!select && selection) {
                ClickNavigator.setCursor(editor, 12);
            } else {
                ClickNavigator.setCursor(editor, 2);
            }
        }
    }

    public static void setCursor(Editor view, @JdkConstants.CursorType int type) {
        Cursor cursor = type == 2 && view instanceof EditorEx ? UIUtil.getTextCursor((Color)((EditorEx)view).getBackgroundColor()) : Cursor.getPredefinedCursor(type);
        view.getContentComponent().setCursor(cursor);
    }
}

