/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionPreselectSkipper;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.StatisticsWeigher;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.codeInsight.lookup.impl.EmptyLookupItem;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElement;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.featureStatistics.FeatureUsageTrackerImpl;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.util.Alarm;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionLookupArranger
extends LookupArranger {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.CompletionLookupArranger");
    @Nullable
    private static StatisticsUpdate ourPendingUpdate;
    private static final Alarm ourStatsAlarm;
    private static final Key<String> GLOBAL_PRESENTATION_INVARIANT;
    private final Key<String> PRESENTATION_INVARIANT = Key.create((String)"PRESENTATION_INVARIANT");
    private final Comparator<LookupElement> BY_PRESENTATION_COMPARATOR = new Comparator<LookupElement>(){

        @Override
        public int compare(LookupElement o1, LookupElement o2) {
            String invariant = (String)CompletionLookupArranger.this.PRESENTATION_INVARIANT.get((UserDataHolder)o1);
            assert (invariant != null);
            return StringUtil.naturalCompare((String)invariant, (String)((String)CompletionLookupArranger.this.PRESENTATION_INVARIANT.get((UserDataHolder)o2)));
        }
    };
    static final int MAX_PREFERRED_COUNT = 5;
    public static final Key<WeighingContext> WEIGHING_CONTEXT;
    public static final Key<Boolean> PURE_RELEVANCE;
    public static final Key<Integer> PREFIX_CHANGES;
    private static final UISettings ourUISettings;
    private final List<LookupElement> myFrozenItems = new ArrayList<LookupElement>();
    private final int myLimit = Registry.intValue((String)"ide.completion.variant.limit");
    private boolean myOverflow;
    private final CompletionLocation myLocation;
    private final CompletionParameters myParameters;
    private final CompletionProgressIndicator myProcess;
    private final Map<CompletionSorterImpl, Classifier<LookupElement>> myClassifiers = new LinkedHashMap<CompletionSorterImpl, Classifier<LookupElement>>();
    private int myPrefixChanges;

    public CompletionLookupArranger(CompletionParameters parameters, CompletionProgressIndicator process) {
        this.myParameters = parameters;
        this.myProcess = process;
        this.myLocation = new CompletionLocation(parameters);
    }

    private MultiMap<CompletionSorterImpl, LookupElement> groupItemsBySorter(Iterable<LookupElement> source) {
        MultiMap inputBySorter = MultiMap.createLinked();
        for (LookupElement element : source) {
            inputBySorter.putValue((Object)this.obtainSorter(element), (Object)element);
        }
        return inputBySorter;
    }

    @NotNull
    private CompletionSorterImpl obtainSorter(LookupElement element) {
        CompletionSorterImpl completionSorterImpl = this.myProcess.getSorter(element);
        if (completionSorterImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionLookupArranger", "obtainSorter"));
        }
        return completionSorterImpl;
    }

    @Override
    @NotNull
    public Map<LookupElement, List<Pair<String, Object>>> getRelevanceObjects(@NotNull Iterable<LookupElement> items, boolean hideSingleValued) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/codeInsight/completion/CompletionLookupArranger", "getRelevanceObjects"));
        }
        LinkedHashMap map = ContainerUtil.newLinkedHashMap();
        MultiMap<CompletionSorterImpl, LookupElement> inputBySorter = this.groupItemsBySorter(items);
        int sorterNumber = 0;
        for (CompletionSorterImpl sorter : inputBySorter.keySet()) {
            ++sorterNumber;
            Collection thisSorterItems = inputBySorter.get((Object)sorter);
            for (LookupElement element : thisSorterItems) {
                map.put(element, ContainerUtil.newArrayList((Object[])new Pair[]{new Pair((Object)"frozen", (Object)this.myFrozenItems.contains(element)), new Pair((Object)"sorter", (Object)sorterNumber)}));
            }
            ProcessingContext context = this.createContext(false);
            for (Classifier<LookupElement> classifier = this.myClassifiers.get((Object)sorter); classifier != null; classifier = classifier.getNext()) {
                final THashSet itemSet = ContainerUtil.newIdentityTroveSet((Collection)thisSorterItems);
                List unsortedItems = ContainerUtil.filter((Collection)this.myItems, (Condition)new Condition<LookupElement>(){

                    public boolean value(LookupElement lookupElement) {
                        return itemSet.contains((Object)lookupElement);
                    }
                });
                List<Pair<LookupElement, Object>> pairs = classifier.getSortingWeights(unsortedItems, context);
                if (hideSingleValued && CompletionLookupArranger.haveSameWeights(pairs)) continue;
                for (Pair<LookupElement, Object> pair : pairs) {
                    ((List)map.get(pair.first)).add(Pair.create((Object)classifier.getPresentableName(), (Object)pair.second));
                }
            }
        }
        LinkedHashMap linkedHashMap = map;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionLookupArranger", "getRelevanceObjects"));
        }
        return linkedHashMap;
    }

    private static boolean haveSameWeights(List<Pair<LookupElement, Object>> pairs) {
        if (pairs.isEmpty()) {
            return true;
        }
        for (int i = 1; i < pairs.size(); ++i) {
            if (Comparing.equal((Object)pairs.get((int)i).second, (Object)pairs.get((int)0).second)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addElement(Lookup lookup, LookupElement element, LookupElementPresentation presentation) {
        StatisticsWeigher.clearBaseStatisticsInfo(element);
        String invariant = presentation.getItemText() + "\u0000###" + CompletionLookupArranger.getTailTextOrSpace(presentation) + "###" + presentation.getTypeText();
        element.putUserData(this.PRESENTATION_INVARIANT, (Object)invariant);
        element.putUserData(GLOBAL_PRESENTATION_INVARIANT, (Object)invariant);
        CompletionSorterImpl sorter = this.obtainSorter(element);
        Classifier<LookupElement> classifier = this.myClassifiers.get((Object)sorter);
        if (classifier == null) {
            classifier = sorter.buildClassifier(new AlphaClassifier((LookupImpl)lookup));
            this.myClassifiers.put(sorter, classifier);
        }
        ProcessingContext context = this.createContext(true);
        classifier.addElement(element, context);
        super.addElement(lookup, element, presentation);
        this.trimToLimit(lookup, context);
    }

    private void trimToLimit(Lookup lookup, ProcessingContext context) {
        if (this.myItems.size() <= this.myLimit * 2) {
            return;
        }
        List<LookupElement> items = this.getMatchingItems();
        Iterator<LookupElement> iterator = this.sortByRelevance(this.groupItemsBySorter(items)).iterator();
        THashSet retainedSet = ContainerUtil.newIdentityTroveSet();
        retainedSet.addAll(this.getPrefixItems(true));
        retainedSet.addAll(this.getPrefixItems(false));
        retainedSet.addAll(this.myFrozenItems);
        while (retainedSet.size() < this.myLimit && iterator.hasNext()) {
            retainedSet.add(iterator.next());
        }
        if (!iterator.hasNext()) {
            return;
        }
        List<LookupElement> removed = this.retainItems((Set<LookupElement>)retainedSet, lookup);
        for (LookupElement element : removed) {
            this.removeItem(element, context);
        }
        if (!this.myOverflow) {
            this.myOverflow = true;
            this.myProcess.addAdvertisement("Not all variants are shown, please type more letters to see the rest", null);
            this.myProcess.addWatchedPrefix(0, (ElementPattern<String>)StandardPatterns.string());
        }
    }

    private void removeItem(LookupElement element, ProcessingContext context) {
        CompletionSorterImpl sorter = this.obtainSorter(element);
        Classifier<LookupElement> classifier = this.myClassifiers.get((Object)sorter);
        classifier.removeElement(element, context);
    }

    @NotNull
    private static String getTailTextOrSpace(LookupElementPresentation presentation) {
        String tailText = presentation.getTailText();
        String string = tailText == null || tailText.isEmpty() ? " " : tailText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionLookupArranger", "getTailTextOrSpace"));
        }
        return string;
    }

    private List<LookupElement> sortByPresentation(Iterable<LookupElement> source, LookupImpl lookup) {
        ArrayList startMatches = ContainerUtil.newArrayList();
        ArrayList middleMatches = ContainerUtil.newArrayList();
        for (LookupElement element : source) {
            (CompletionServiceImpl.isStartMatch(element, lookup) ? startMatches : middleMatches).add(element);
        }
        ContainerUtil.sort((List)startMatches, this.BY_PRESENTATION_COMPARATOR);
        ContainerUtil.sort((List)middleMatches, this.BY_PRESENTATION_COMPARATOR);
        startMatches.addAll(middleMatches);
        return startMatches;
    }

    private static boolean isAlphaSorted() {
        return CompletionLookupArranger.ourUISettings.SORT_LOOKUP_ELEMENTS_LEXICOGRAPHICALLY;
    }

    @Override
    public Pair<List<LookupElement>, Integer> arrangeItems(@NotNull Lookup lookup, boolean onExplicitAction) {
        if (lookup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookup", "com/intellij/codeInsight/completion/CompletionLookupArranger", "arrangeItems"));
        }
        List<LookupElement> items = this.getMatchingItems();
        MultiMap<CompletionSorterImpl, LookupElement> itemsBySorter = this.groupItemsBySorter(items);
        LookupElement relevantSelection = this.findMostRelevantItem(itemsBySorter);
        LookupImpl lookupImpl = (LookupImpl)lookup;
        List<LookupElement> listModel = CompletionLookupArranger.isAlphaSorted() ? this.sortByPresentation(items, lookupImpl) : this.fillModelByRelevance(lookupImpl, (Set<LookupElement>)ContainerUtil.newIdentityTroveSet(items), itemsBySorter, relevantSelection);
        int toSelect = this.getItemToSelect(lookupImpl, listModel, onExplicitAction, relevantSelection);
        LOG.assertTrue(toSelect >= 0);
        CompletionLookupArranger.addDummyItems(items.size() - listModel.size(), listModel);
        return new Pair(listModel, (Object)toSelect);
    }

    private static void addDummyItems(int count, List<LookupElement> listModel) {
        EmptyLookupItem dummy = new EmptyLookupItem("loading...", true);
        for (int i = count; i > 0; --i) {
            listModel.add(dummy);
        }
    }

    private List<LookupElement> fillModelByRelevance(LookupImpl lookup, Set<LookupElement> items, MultiMap<CompletionSorterImpl, LookupElement> inputBySorter, @Nullable LookupElement relevantSelection) {
        Iterator<LookupElement> byRelevance = this.sortByRelevance(inputBySorter).iterator();
        final LinkedHashSet<LookupElement> model = new LinkedHashSet<LookupElement>();
        this.addPrefixItems(model);
        this.addFrozenItems(items, model);
        CompletionLookupArranger.addSomeItems(model, byRelevance, new Condition<LookupElement>(){

            public boolean value(LookupElement lastAdded) {
                return model.size() >= 5;
            }
        });
        CompletionLookupArranger.addCurrentlySelectedItemToTop(lookup, items, model);
        this.freezeTopItems(lookup, model);
        CompletionLookupArranger.ensureItemAdded(items, model, byRelevance, lookup.getCurrentItem());
        CompletionLookupArranger.ensureItemAdded(items, model, byRelevance, relevantSelection);
        CompletionLookupArranger.ensureEverythingVisibleAdded(lookup, model, byRelevance);
        return new ArrayList<LookupElement>(model);
    }

    private static void ensureEverythingVisibleAdded(LookupImpl lookup, final LinkedHashSet<LookupElement> model, Iterator<LookupElement> byRelevance) {
        JList list = lookup.getList();
        final boolean testMode = ApplicationManager.getApplication().isUnitTestMode();
        final int limit = Math.max(list.getLastVisibleIndex(), model.size()) + CompletionLookupArranger.ourUISettings.MAX_LOOKUP_LIST_HEIGHT * 3;
        CompletionLookupArranger.addSomeItems(model, byRelevance, new Condition<LookupElement>(){

            public boolean value(LookupElement lastAdded) {
                return !testMode && model.size() >= limit;
            }
        });
    }

    private static void ensureItemAdded(Set<LookupElement> items, LinkedHashSet<LookupElement> model, Iterator<LookupElement> byRelevance, final @Nullable LookupElement item) {
        if (item != null && items.contains(item) && !model.contains(item)) {
            CompletionLookupArranger.addSomeItems(model, byRelevance, new Condition<LookupElement>(){

                public boolean value(LookupElement lastAdded) {
                    return lastAdded == item;
                }
            });
        }
    }

    private void freezeTopItems(LookupImpl lookup, LinkedHashSet<LookupElement> model) {
        this.myFrozenItems.clear();
        if (lookup.isShown()) {
            this.myFrozenItems.addAll(model);
        }
    }

    private void addFrozenItems(Set<LookupElement> items, LinkedHashSet<LookupElement> model) {
        Iterator<LookupElement> iterator = this.myFrozenItems.iterator();
        while (iterator.hasNext()) {
            LookupElement element = iterator.next();
            if (element.isValid() && items.contains(element)) continue;
            iterator.remove();
        }
        model.addAll(this.myFrozenItems);
    }

    private void addPrefixItems(LinkedHashSet<LookupElement> model) {
        ContainerUtil.addAll(model, this.sortByRelevance(this.groupItemsBySorter(this.getPrefixItems(true))));
        ContainerUtil.addAll(model, this.sortByRelevance(this.groupItemsBySorter(this.getPrefixItems(false))));
    }

    private static void addCurrentlySelectedItemToTop(Lookup lookup, Set<LookupElement> items, LinkedHashSet<LookupElement> model) {
        LookupElement lastSelection;
        if (!lookup.isSelectionTouched() && items.contains(lastSelection = lookup.getCurrentItem())) {
            model.add(lastSelection);
        }
    }

    private static void addSomeItems(LinkedHashSet<LookupElement> model, Iterator<LookupElement> iterator, Condition<LookupElement> stopWhen) {
        while (iterator.hasNext()) {
            LookupElement item = iterator.next();
            model.add(item);
            if (!stopWhen.value((Object)item)) continue;
            break;
        }
    }

    private Iterable<LookupElement> sortByRelevance(MultiMap<CompletionSorterImpl, LookupElement> inputBySorter) {
        ArrayList byClassifier = ContainerUtil.newArrayList();
        for (CompletionSorterImpl sorter : this.myClassifiers.keySet()) {
            ProcessingContext context = this.createContext(false);
            byClassifier.add(this.myClassifiers.get((Object)sorter).classify(inputBySorter.get((Object)sorter), context));
        }
        return ContainerUtil.concat((Iterable[])byClassifier.toArray(new Iterable[byClassifier.size()]));
    }

    private ProcessingContext createContext(boolean pureRelevance) {
        ProcessingContext context = new ProcessingContext();
        context.put(PREFIX_CHANGES, (Object)this.myPrefixChanges);
        context.put(WEIGHING_CONTEXT, (Object)this.myProcess.getLookup());
        if (pureRelevance) {
            context.put(PURE_RELEVANCE, (Object)Boolean.TRUE);
        }
        return context;
    }

    @Override
    public LookupArranger createEmptyCopy() {
        return new CompletionLookupArranger(this.myParameters, this.myProcess);
    }

    private int getItemToSelect(LookupImpl lookup, List<LookupElement> items, boolean onExplicitAction, @Nullable LookupElement mostRelevant) {
        if (items.isEmpty() || lookup.getFocusDegree() == LookupImpl.FocusDegree.UNFOCUSED) {
            return 0;
        }
        if (lookup.isSelectionTouched() || !onExplicitAction) {
            int index;
            LookupElement lastSelection = lookup.getCurrentItem();
            int old = ContainerUtil.indexOfIdentity(items, (Object)lastSelection);
            if (old >= 0) {
                return old;
            }
            Object selectedValue = lookup.getList().getSelectedValue();
            if (selectedValue instanceof EmptyLookupItem && ((EmptyLookupItem)((Object)selectedValue)).isLoading() && (index = lookup.getList().getSelectedIndex()) >= 0 && index < items.size()) {
                return index;
            }
            for (int i = 0; i < items.size(); ++i) {
                String invariant = (String)this.PRESENTATION_INVARIANT.get((UserDataHolder)items.get(i));
                if (invariant == null || !invariant.equals(GLOBAL_PRESENTATION_INVARIANT.get((UserDataHolder)lastSelection))) continue;
                return i;
            }
        }
        String selectedText = lookup.getTopLevelEditor().getSelectionModel().getSelectedText();
        int exactMatchIndex = -1;
        for (int i = 0; i < items.size(); ++i) {
            LookupElement item = items.get(i);
            boolean isSuddenLiveTemplate = CompletionLookupArranger.isSuddenLiveTemplate(item);
            if (CompletionLookupArranger.isPrefixItem(lookup, item, true) && !isSuddenLiveTemplate || item.getLookupString().equals(selectedText)) {
                if (item instanceof LiveTemplateLookupElement) {
                    exactMatchIndex = i;
                    break;
                }
                if (exactMatchIndex != -1) continue;
                exactMatchIndex = i;
                continue;
            }
            if (i != 0 || !isSuddenLiveTemplate || items.size() <= 1 || CompletionServiceImpl.isStartMatch(items.get(1), lookup)) continue;
            return 0;
        }
        if (exactMatchIndex >= 0) {
            return exactMatchIndex;
        }
        return Math.max(0, ContainerUtil.indexOfIdentity(items, (Object)mostRelevant));
    }

    @Nullable
    private LookupElement findMostRelevantItem(MultiMap<CompletionSorterImpl, LookupElement> itemsBySorter) {
        CompletionPreselectSkipper[] skippers = (CompletionPreselectSkipper[])CompletionPreselectSkipper.EP_NAME.getExtensions();
        for (CompletionSorterImpl sorter : this.myClassifiers.keySet()) {
            ProcessingContext context = this.createContext(true);
            for (LookupElement element : this.myClassifiers.get((Object)sorter).classify(itemsBySorter.get((Object)sorter), context)) {
                if (this.shouldSkip(skippers, element)) continue;
                return element;
            }
        }
        return null;
    }

    private static boolean isSuddenLiveTemplate(LookupElement element) {
        return element instanceof LiveTemplateLookupElement && ((LiveTemplateLookupElement)element).sudden;
    }

    public static StatisticsUpdate collectStatisticChanges(LookupElement item, Lookup lookup) {
        StatisticsUpdate update;
        CompletionLookupArranger.applyLastCompletionStatisticsUpdate();
        StatisticsInfo base = StatisticsWeigher.getBaseStatisticsInfo(item, null);
        if (base == StatisticsInfo.EMPTY) {
            return new StatisticsUpdate(StatisticsInfo.EMPTY);
        }
        ourPendingUpdate = update = new StatisticsUpdate(StatisticsWeigher.composeStatsWithPrefix(base, lookup.itemPattern(item), true));
        Disposer.register((Disposable)update, (Disposable)new Disposable(){

            public void dispose() {
                ourPendingUpdate = null;
            }
        });
        return update;
    }

    public static void trackStatistics(InsertionContext context, final StatisticsUpdate update) {
        if (ourPendingUpdate != update) {
            return;
        }
        final Document document = context.getDocument();
        int startOffset = context.getStartOffset();
        int tailOffset = context.getEditor().getCaretModel().getOffset();
        if (startOffset < 0 || tailOffset <= startOffset) {
            return;
        }
        final RangeMarker marker = document.createRangeMarker(startOffset, tailOffset);
        final DocumentAdapter listener2 = new DocumentAdapter(){

            public void beforeDocumentChange(DocumentEvent e) {
                if (!marker.isValid() || e.getOffset() > marker.getStartOffset() && e.getOffset() < marker.getEndOffset()) {
                    CompletionLookupArranger.cancelLastCompletionStatisticsUpdate();
                }
            }
        };
        ourStatsAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (ourPendingUpdate == update) {
                    CompletionLookupArranger.applyLastCompletionStatisticsUpdate();
                }
            }
        }, 20000);
        document.addDocumentListener((DocumentListener)listener2);
        Disposer.register((Disposable)update, (Disposable)new Disposable(){

            public void dispose() {
                document.removeDocumentListener((DocumentListener)listener2);
                marker.dispose();
                ourStatsAlarm.cancelAllRequests();
            }
        });
    }

    public static void cancelLastCompletionStatisticsUpdate() {
        if (ourPendingUpdate != null) {
            Disposer.dispose((Disposable)ourPendingUpdate);
            assert (ourPendingUpdate == null);
        }
    }

    public static void applyLastCompletionStatisticsUpdate() {
        StatisticsUpdate update = ourPendingUpdate;
        if (update != null) {
            update.performUpdate();
            Disposer.dispose((Disposable)update);
            assert (ourPendingUpdate == null);
        }
    }

    private boolean shouldSkip(CompletionPreselectSkipper[] skippers, LookupElement element) {
        for (CompletionPreselectSkipper skipper : skippers) {
            if (!skipper.skipElement(element, this.myLocation)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipped element " + element + " by " + skipper);
            }
            return true;
        }
        return false;
    }

    @Override
    public void prefixChanged(Lookup lookup) {
        ++this.myPrefixChanges;
        this.myFrozenItems.clear();
        super.prefixChanged(lookup);
    }

    static {
        ourStatsAlarm = new Alarm((Disposable)ApplicationManager.getApplication());
        GLOBAL_PRESENTATION_INVARIANT = Key.create((String)"PRESENTATION_INVARIANT");
        WEIGHING_CONTEXT = Key.create((String)"WEIGHING_CONTEXT");
        PURE_RELEVANCE = Key.create((String)"PURE_RELEVANCE");
        PREFIX_CHANGES = Key.create((String)"PREFIX_CHANGES");
        ourUISettings = UISettings.getInstance();
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)new Disposable(){

            public void dispose() {
                CompletionLookupArranger.cancelLastCompletionStatisticsUpdate();
            }
        });
    }

    private class AlphaClassifier
    extends Classifier<LookupElement> {
        private final LookupImpl myLookup;

        private AlphaClassifier(LookupImpl lookup) {
            super(null, "alpha");
            this.myLookup = lookup;
        }

        @Override
        @NotNull
        public List<Pair<LookupElement, Object>> getSortingWeights(@NotNull Iterable<LookupElement> items, @NotNull ProcessingContext context) {
            if (items == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/codeInsight/completion/CompletionLookupArranger$AlphaClassifier", "getSortingWeights"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/completion/CompletionLookupArranger$AlphaClassifier", "getSortingWeights"));
            }
            List<Pair<LookupElement, Object>> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionLookupArranger$AlphaClassifier", "getSortingWeights"));
            }
            return list;
        }

        @Override
        @NotNull
        public Iterable<LookupElement> classify(@NotNull Iterable<LookupElement> source, @NotNull ProcessingContext context) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/codeInsight/completion/CompletionLookupArranger$AlphaClassifier", "classify"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/completion/CompletionLookupArranger$AlphaClassifier", "classify"));
            }
            List list = CompletionLookupArranger.this.sortByPresentation(source, this.myLookup);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionLookupArranger$AlphaClassifier", "classify"));
            }
            return list;
        }
    }

    static class StatisticsUpdate
    implements Disposable {
        private final StatisticsInfo myInfo;
        private int mySpared;

        public StatisticsUpdate(StatisticsInfo info) {
            this.myInfo = info;
        }

        void performUpdate() {
            this.myInfo.incUseCount();
            ((FeatureUsageTrackerImpl)FeatureUsageTracker.getInstance()).getCompletionStatistics().registerInvocation(this.mySpared);
        }

        public void dispose() {
        }

        public void addSparedChars(CompletionProgressIndicator indicator, LookupElement item, InsertionContext context, char completionChar) {
            String textInserted = context.getStartOffset() >= 0 && context.getTailOffset() >= context.getStartOffset() ? context.getDocument().getImmutableCharSequence().subSequence(context.getStartOffset(), context.getTailOffset()).toString() : item.getLookupString();
            String withoutSpaces = StringUtil.replace((String)textInserted, (String[])new String[]{" ", "\t", "\n"}, (String[])new String[]{"", "", ""});
            int spared = withoutSpaces.length() - indicator.getLookup().itemPattern(item).length();
            if (!LookupEvent.isSpecialCompletionChar((char)completionChar) && withoutSpaces.contains(String.valueOf(completionChar))) {
                --spared;
            }
            if (spared > 0) {
                this.mySpared += spared;
            }
        }
    }
}

