/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypeInfoImpl;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionStatistician;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.RecursionWeigher;
import com.intellij.codeInsight.completion.ReferenceExpressionCompletionContributor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.statistics.JavaStatisticsManager;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;

public class JavaCompletionStatistician
extends CompletionStatistician {
    private static final ElementPattern<PsiElement> SUPER_CALL = PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText(".")).afterLeaf(new String[]{"super"}));

    public StatisticsInfo serialize(LookupElement element, CompletionLocation location) {
        Object o = element.getObject();
        if (o instanceof PsiLocalVariable || o instanceof PsiParameter || o instanceof PsiThisExpression || o instanceof PsiKeyword) {
            return StatisticsInfo.EMPTY;
        }
        PsiElement position = location.getCompletionParameters().getPosition();
        if (SUPER_CALL.accepts((Object)position) || ReferenceExpressionCompletionContributor.IN_SWITCH_LABEL.accepts((Object)position)) {
            return StatisticsInfo.EMPTY;
        }
        LookupItem item = (LookupItem)element.as(LookupItem.CLASS_CONDITION_KEY);
        if (item == null) {
            return null;
        }
        PsiType qualifierType = JavaCompletionUtil.getQualifierType((LookupElement)item);
        if (o instanceof PsiMember) {
            ExpectedTypeInfo[] infos = (ExpectedTypeInfo[])JavaCompletionUtil.EXPECTED_TYPES.getValue((UserDataHolder)location);
            ExpectedTypeInfo firstInfo = infos != null && infos.length > 0 ? infos[0] : null;
            String key2 = JavaStatisticsManager.getMemberUseKey2((PsiMember)((PsiMember)o));
            if (o instanceof PsiClass) {
                PsiType expectedType = firstInfo != null ? firstInfo.getDefaultType() : null;
                return new StatisticsInfo(JavaStatisticsManager.getAfterNewKey((PsiType)expectedType), key2);
            }
            PsiClass containingClass = ((PsiMember)o).getContainingClass();
            if (containingClass != null) {
                String expectedName = firstInfo instanceof ExpectedTypeInfoImpl ? ((ExpectedTypeInfoImpl)firstInfo).getExpectedName() : null;
                String contextPrefix = expectedName == null ? "" : "expectedName=" + expectedName + "###";
                String context = contextPrefix + JavaStatisticsManager.getMemberUseKey2((PsiMember)containingClass);
                if (o instanceof PsiMethod) {
                    String memberValue = JavaStatisticsManager.getMemberUseKey2((PsiMember)RecursionWeigher.findDeepestSuper((PsiMethod)o));
                    ArrayList superMethodInfos = ContainerUtil.newArrayList((Object[])new StatisticsInfo[]{new StatisticsInfo(contextPrefix + context, memberValue)});
                    for (PsiClass superClass : InheritanceUtil.getSuperClasses((PsiClass)containingClass)) {
                        superMethodInfos.add(new StatisticsInfo(contextPrefix + JavaStatisticsManager.getMemberUseKey2((PsiMember)superClass), memberValue));
                    }
                    return StatisticsInfo.createComposite((List)superMethodInfos);
                }
                return new StatisticsInfo(context, key2);
            }
        }
        if (qualifierType != null) {
            return StatisticsInfo.EMPTY;
        }
        return null;
    }
}

