/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.actions.CleanupIntention;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nullable;

class CleanupOnScopeIntention
extends CleanupIntention {
    static final CleanupOnScopeIntention INSTANCE = new CleanupOnScopeIntention();

    private CleanupOnScopeIntention() {
    }

    @Override
    @Nullable
    protected AnalysisScope getScope(Project project2, PsiFile file2) {
        BaseAnalysisActionDialog dlg;
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)file2);
        AnalysisScope analysisScope = new AnalysisScope(file2);
        VirtualFile virtualFile = file2.getVirtualFile();
        if (file2.isPhysical() || virtualFile == null || !virtualFile.isInLocalFileSystem()) {
            analysisScope = new AnalysisScope(project2);
        }
        if (!(dlg = new BaseAnalysisActionDialog(AnalysisScopeBundle.message((String)"specify.analysis.scope", (Object[])new Object[]{InspectionsBundle.message((String)"inspection.action.title", (Object[])new Object[0])}), AnalysisScopeBundle.message((String)"analysis.scope.title", (Object[])new Object[]{InspectionsBundle.message((String)"inspection.action.noun", (Object[])new Object[0])}), project2, analysisScope, module2 != null ? module2.getName() : null, true, AnalysisUIOptions.getInstance(project2), (PsiElement)file2)).showAndGet()) {
            return null;
        }
        AnalysisUIOptions uiOptions = AnalysisUIOptions.getInstance(project2);
        return dlg.getScope(uiOptions, analysisScope, project2, module2);
    }
}

